/*
 * Copyright 2010-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.cognitoidentityprovider.model;

import java.util.HashMap;
import java.util.Map;

/**
 * User Import Job Status Type
 */
public enum UserImportJobStatusType {

    Created("Created"),
    Pending("Pending"),
    InProgress("InProgress"),
    Stopping("Stopping"),
    Expired("Expired"),
    Stopped("Stopped"),
    Failed("Failed"),
    Succeeded("Succeeded");

    private String value;

    private UserImportJobStatusType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    private static final Map<String, UserImportJobStatusType> enumMap;
    static {
        enumMap = new HashMap<String, UserImportJobStatusType>();
        enumMap.put("Created", Created);
        enumMap.put("Pending", Pending);
        enumMap.put("InProgress", InProgress);
        enumMap.put("Stopping", Stopping);
        enumMap.put("Expired", Expired);
        enumMap.put("Stopped", Stopped);
        enumMap.put("Failed", Failed);
        enumMap.put("Succeeded", Succeeded);
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value real value
     * @return UserImportJobStatusType corresponding to the value
     */
    public static UserImportJobStatusType fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        } else if (enumMap.containsKey(value)) {
            return enumMap.get(value);
        } else {
            throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
        }
    }
}
