/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.AuthFlowType;
import com.amazonaws.services.cognitoidentityprovider.model.UserContextDataType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InitiateAuthRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String authFlow;
    private Map<String, String> authParameters;
    private Map<String, String> clientMetadata;
    private String clientId;
    private UserContextDataType userContextData;
    private AnalyticsMetadataType analyticsMetadata;

    public String getAuthFlow() {
        return this.authFlow;
    }

    public void setAuthFlow(String authFlow) {
        this.authFlow = authFlow;
    }

    public InitiateAuthRequest withAuthFlow(String authFlow) {
        this.authFlow = authFlow;
        return this;
    }

    public void setAuthFlow(AuthFlowType authFlow) {
        this.authFlow = authFlow.toString();
    }

    public InitiateAuthRequest withAuthFlow(AuthFlowType authFlow) {
        this.authFlow = authFlow.toString();
        return this;
    }

    public Map<String, String> getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(Map<String, String> authParameters) {
        this.authParameters = authParameters;
    }

    public InitiateAuthRequest withAuthParameters(Map<String, String> authParameters) {
        this.authParameters = authParameters;
        return this;
    }

    public InitiateAuthRequest addAuthParametersEntry(String key, String value) {
        if (null == this.authParameters) {
            this.authParameters = new HashMap<String, String>();
        }
        if (this.authParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.authParameters.put(key, value);
        return this;
    }

    public InitiateAuthRequest clearAuthParametersEntries() {
        this.authParameters = null;
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public InitiateAuthRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        return this;
    }

    public InitiateAuthRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public InitiateAuthRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public InitiateAuthRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public UserContextDataType getUserContextData() {
        return this.userContextData;
    }

    public void setUserContextData(UserContextDataType userContextData) {
        this.userContextData = userContextData;
    }

    public InitiateAuthRequest withUserContextData(UserContextDataType userContextData) {
        this.userContextData = userContextData;
        return this;
    }

    public AnalyticsMetadataType getAnalyticsMetadata() {
        return this.analyticsMetadata;
    }

    public void setAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
    }

    public InitiateAuthRequest withAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthFlow() != null) {
            sb.append("AuthFlow: " + this.getAuthFlow() + ",");
        }
        if (this.getAuthParameters() != null) {
            sb.append("AuthParameters: " + this.getAuthParameters() + ",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: " + this.getClientMetadata() + ",");
        }
        if (this.getClientId() != null) {
            sb.append("ClientId: " + this.getClientId() + ",");
        }
        if (this.getUserContextData() != null) {
            sb.append("UserContextData: " + this.getUserContextData() + ",");
        }
        if (this.getAnalyticsMetadata() != null) {
            sb.append("AnalyticsMetadata: " + this.getAnalyticsMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthFlow() == null ? 0 : this.getAuthFlow().hashCode());
        hashCode = 31 * hashCode + (this.getAuthParameters() == null ? 0 : this.getAuthParameters().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getUserContextData() == null ? 0 : this.getUserContextData().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyticsMetadata() == null ? 0 : this.getAnalyticsMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateAuthRequest)) {
            return false;
        }
        InitiateAuthRequest other = (InitiateAuthRequest)obj;
        if (other.getAuthFlow() == null ^ this.getAuthFlow() == null) {
            return false;
        }
        if (other.getAuthFlow() != null && !other.getAuthFlow().equals(this.getAuthFlow())) {
            return false;
        }
        if (other.getAuthParameters() == null ^ this.getAuthParameters() == null) {
            return false;
        }
        if (other.getAuthParameters() != null && !other.getAuthParameters().equals(this.getAuthParameters())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        if (other.getClientMetadata() != null && !other.getClientMetadata().equals(this.getClientMetadata())) {
            return false;
        }
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getUserContextData() == null ^ this.getUserContextData() == null) {
            return false;
        }
        if (other.getUserContextData() != null && !other.getUserContextData().equals(this.getUserContextData())) {
            return false;
        }
        if (other.getAnalyticsMetadata() == null ^ this.getAnalyticsMetadata() == null) {
            return false;
        }
        return other.getAnalyticsMetadata() == null || other.getAnalyticsMetadata().equals(this.getAnalyticsMetadata());
    }
}

