package com.amazonaws.cognito.clientcontext.datacollection;

import java.util.HashMap;
import java.util.Map;

import android.content.Context;
import android.os.Build;

/**
 * It collects build information for underlying device hardware.
 */
public class BuildDataCollector extends DataCollector {

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<String, String> collect(Context context) {
        Map<String, String> contextData = new HashMap<String, String>();
        contextData.put(DataRecordKey.BRAND, Build.BRAND);
        contextData.put(DataRecordKey.FINGERPRINT, Build.FINGERPRINT);
        contextData.put(DataRecordKey.HARDWARE, Build.HARDWARE);
        contextData.put(DataRecordKey.MODEL, Build.MODEL);
        contextData.put(DataRecordKey.PRODUCT, Build.PRODUCT);
        contextData.put(DataRecordKey.BUILD_TYPE, Build.TYPE);
        contextData.put(DataRecordKey.VERSION_RELEASE, Build.VERSION.RELEASE);
        contextData.put(DataRecordKey.VERSION_SDK, Build.VERSION.SDK);
        return contextData;
    }
}