/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddCustomAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userPoolId;
    private List<SchemaAttributeType> customAttributes;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public AddCustomAttributesRequest withUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
        return this;
    }

    public List<SchemaAttributeType> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Collection<SchemaAttributeType> customAttributes) {
        if (customAttributes == null) {
            this.customAttributes = null;
            return;
        }
        this.customAttributes = new ArrayList<SchemaAttributeType>(customAttributes);
    }

    public AddCustomAttributesRequest withCustomAttributes(SchemaAttributeType ... customAttributes) {
        if (this.getCustomAttributes() == null) {
            this.customAttributes = new ArrayList<SchemaAttributeType>(customAttributes.length);
        }
        for (SchemaAttributeType value : customAttributes) {
            this.customAttributes.add(value);
        }
        return this;
    }

    public AddCustomAttributesRequest withCustomAttributes(Collection<SchemaAttributeType> customAttributes) {
        this.setCustomAttributes(customAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getCustomAttributes() != null) {
            sb.append("CustomAttributes: " + this.getCustomAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAttributes() == null ? 0 : this.getCustomAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCustomAttributesRequest)) {
            return false;
        }
        AddCustomAttributesRequest other = (AddCustomAttributesRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getCustomAttributes() == null ^ this.getCustomAttributes() == null) {
            return false;
        }
        return other.getCustomAttributes() == null || other.getCustomAttributes().equals(this.getCustomAttributes());
    }
}

