/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AuthenticateRequest;
import com.amazonaws.services.cognitoidentityprovider.model.PasswordClaimType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.PasswordClaimTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

public class AuthenticateRequestMarshaller
implements Marshaller<Request<AuthenticateRequest>, AuthenticateRequest> {
    public Request<AuthenticateRequest> marshall(AuthenticateRequest authenticateRequest) {
        if (authenticateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AuthenticateRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authenticateRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.Authenticate";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (authenticateRequest.getClientId() != null) {
                String clientId = authenticateRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (authenticateRequest.getSecretHash() != null) {
                String secretHash = authenticateRequest.getSecretHash();
                jsonWriter.name("SecretHash");
                jsonWriter.value(secretHash);
            }
            if (authenticateRequest.getUsername() != null) {
                String username = authenticateRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (authenticateRequest.getPasswordClaim() != null) {
                PasswordClaimType passwordClaim = authenticateRequest.getPasswordClaim();
                jsonWriter.name("PasswordClaim");
                PasswordClaimTypeJsonMarshaller.getInstance().marshall(passwordClaim, jsonWriter);
            }
            if (authenticateRequest.getTimestamp() != null) {
                Date timestamp = authenticateRequest.getTimestamp();
                jsonWriter.name("Timestamp");
                jsonWriter.value(timestamp);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

