/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ChooseMfaContinuation
extends ChallengeContinuation {
    private List<String> mfaOptions = this.getListFromString((String)this.getParameters().get("MFAS_CAN_CHOOSE"));

    public ChooseMfaContinuation(CognitoUser user, Context context, String username, String clientId, String secretHash, RespondToAuthChallengeResult challengeResult, boolean runInBackground, AuthenticationHandler callback) {
        super(user, context, username, clientId, secretHash, challengeResult, runInBackground, callback);
    }

    public List<String> getMfaOptions() {
        if (this.mfaOptions == null) {
            this.mfaOptions = this.getListFromString((String)this.getParameters().get("MFAS_CAN_CHOOSE"));
        }
        return this.mfaOptions;
    }

    public void setMfaOption(String option) {
        List<String> availableOptions = this.getMfaOptions();
        if (option == null || !availableOptions.contains(option)) {
            throw new CognitoParameterInvalidException(String.format(Locale.US, "invalid MFA option: %s", option));
        }
        this.setChallengeResponse("ANSWER", option);
    }

    @Override
    public void continueTask() {
        if (!this.challengeResponses.containsKey("ANSWER")) {
            throw new CognitoParameterInvalidException("MFA option is not set");
        }
        super.continueTask();
    }

    private List<String> getListFromString(String listString) {
        String mfas = listString.replace("[", "").replace("]", "").replace("\"", "");
        return Arrays.asList(mfas.split(","));
    }
}

