/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SignUpRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clientId;
    private String secretHash;
    private String username;
    private String password;
    private ListWithAutoConstructFlag<AttributeType> userAttributes;
    private ListWithAutoConstructFlag<AttributeType> validationData;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SignUpRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getSecretHash() {
        return this.secretHash;
    }

    public void setSecretHash(String secretHash) {
        this.secretHash = secretHash;
    }

    public SignUpRequest withSecretHash(String secretHash) {
        this.secretHash = secretHash;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public SignUpRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SignUpRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        if (this.userAttributes == null) {
            this.userAttributes = new ListWithAutoConstructFlag();
            this.userAttributes.setAutoConstruct(true);
        }
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        ListWithAutoConstructFlag userAttributesCopy = new ListWithAutoConstructFlag(userAttributes.size());
        userAttributesCopy.addAll(userAttributes);
        this.userAttributes = userAttributesCopy;
    }

    public SignUpRequest withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.setUserAttributes(new ArrayList<AttributeType>(userAttributes.length));
        }
        for (AttributeType value : userAttributes) {
            this.getUserAttributes().add(value);
        }
        return this;
    }

    public SignUpRequest withUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
        } else {
            ListWithAutoConstructFlag userAttributesCopy = new ListWithAutoConstructFlag(userAttributes.size());
            userAttributesCopy.addAll(userAttributes);
            this.userAttributes = userAttributesCopy;
        }
        return this;
    }

    public List<AttributeType> getValidationData() {
        if (this.validationData == null) {
            this.validationData = new ListWithAutoConstructFlag();
            this.validationData.setAutoConstruct(true);
        }
        return this.validationData;
    }

    public void setValidationData(Collection<AttributeType> validationData) {
        if (validationData == null) {
            this.validationData = null;
            return;
        }
        ListWithAutoConstructFlag validationDataCopy = new ListWithAutoConstructFlag(validationData.size());
        validationDataCopy.addAll(validationData);
        this.validationData = validationDataCopy;
    }

    public SignUpRequest withValidationData(AttributeType ... validationData) {
        if (this.getValidationData() == null) {
            this.setValidationData(new ArrayList<AttributeType>(validationData.length));
        }
        for (AttributeType value : validationData) {
            this.getValidationData().add(value);
        }
        return this;
    }

    public SignUpRequest withValidationData(Collection<AttributeType> validationData) {
        if (validationData == null) {
            this.validationData = null;
        } else {
            ListWithAutoConstructFlag validationDataCopy = new ListWithAutoConstructFlag(validationData.size());
            validationDataCopy.addAll(validationData);
            this.validationData = validationDataCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientId() != null) {
            sb.append("ClientId: " + this.getClientId() + ",");
        }
        if (this.getSecretHash() != null) {
            sb.append("SecretHash: " + this.getSecretHash() + ",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: " + this.getPassword() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getValidationData() != null) {
            sb.append("ValidationData: " + this.getValidationData());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getSecretHash() == null ? 0 : this.getSecretHash().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getValidationData() == null ? 0 : this.getValidationData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpRequest)) {
            return false;
        }
        SignUpRequest other = (SignUpRequest)obj;
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getSecretHash() == null ^ this.getSecretHash() == null) {
            return false;
        }
        if (other.getSecretHash() != null && !other.getSecretHash().equals(this.getSecretHash())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getValidationData() == null ^ this.getValidationData() == null) {
            return false;
        }
        return other.getValidationData() == null || other.getValidationData().equals(this.getValidationData());
    }
}

