/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;

public class MultiFactorAuthenticationContinuation
implements CognitoIdentityProviderContinuation<CognitoUserCodeDeliveryDetails> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final AuthenticationHandler callback;
    private final CognitoUser user;
    private final String authState;
    private final boolean runInBackground;
    private String mfaCode = null;
    private CognitoUserCodeDeliveryDetails parameters = null;

    public MultiFactorAuthenticationContinuation(CognitoUser user, String authState, CognitoUserCodeDeliveryDetails codeDeliveryDetails, boolean runInBackground, AuthenticationHandler callback) {
        this.user = user;
        this.authState = authState;
        this.callback = callback;
        this.runInBackground = runInBackground;
        this.parameters = codeDeliveryDetails;
    }

    @Override
    public CognitoUserCodeDeliveryDetails getParameters() {
        return this.parameters;
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            this.user.sendMFACodeInBackground(this.mfaCode, this.authState, this.parameters, this.callback);
        } else {
            this.user.sendMFACode(this.mfaCode, this.authState, this.parameters, this.callback);
        }
    }

    public void setMfaCode(String mfaCode) {
        this.mfaCode = mfaCode;
    }
}

