/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.ContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsMetadataTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ContextDataTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class AdminInitiateAuthRequestMarshaller
implements Marshaller<Request<AdminInitiateAuthRequest>, AdminInitiateAuthRequest> {
    public Request<AdminInitiateAuthRequest> marshall(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        if (adminInitiateAuthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AdminInitiateAuthRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminInitiateAuthRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminInitiateAuth";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminInitiateAuthRequest.getUserPoolId() != null) {
                String userPoolId = adminInitiateAuthRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (adminInitiateAuthRequest.getClientId() != null) {
                String clientId = adminInitiateAuthRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (adminInitiateAuthRequest.getAuthFlow() != null) {
                String authFlow = adminInitiateAuthRequest.getAuthFlow();
                jsonWriter.name("AuthFlow");
                jsonWriter.value(authFlow);
            }
            if (adminInitiateAuthRequest.getAuthParameters() != null) {
                Map<String, String> authParameters = adminInitiateAuthRequest.getAuthParameters();
                jsonWriter.name("AuthParameters");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> authParametersEntry : authParameters.entrySet()) {
                    String authParametersValue = authParametersEntry.getValue();
                    if (authParametersValue == null) continue;
                    jsonWriter.name(authParametersEntry.getKey());
                    jsonWriter.value(authParametersValue);
                }
                jsonWriter.endObject();
            }
            if (adminInitiateAuthRequest.getClientMetadata() != null) {
                Map<String, String> clientMetadata = adminInitiateAuthRequest.getClientMetadata();
                jsonWriter.name("ClientMetadata");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> clientMetadataEntry : clientMetadata.entrySet()) {
                    String clientMetadataValue = clientMetadataEntry.getValue();
                    if (clientMetadataValue == null) continue;
                    jsonWriter.name(clientMetadataEntry.getKey());
                    jsonWriter.value(clientMetadataValue);
                }
                jsonWriter.endObject();
            }
            if (adminInitiateAuthRequest.getAnalyticsMetadata() != null) {
                AnalyticsMetadataType analyticsMetadata = adminInitiateAuthRequest.getAnalyticsMetadata();
                jsonWriter.name("AnalyticsMetadata");
                AnalyticsMetadataTypeJsonMarshaller.getInstance().marshall(analyticsMetadata, jsonWriter);
            }
            if (adminInitiateAuthRequest.getContextData() != null) {
                ContextDataType contextData = adminInitiateAuthRequest.getContextData();
                jsonWriter.name("ContextData");
                ContextDataTypeJsonMarshaller.getInstance().marshall(contextData, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

