/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.ContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.HttpHeaderJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class ContextDataTypeJsonUnmarshaller
implements Unmarshaller<ContextDataType, JsonUnmarshallerContext> {
    private static ContextDataTypeJsonUnmarshaller instance;

    ContextDataTypeJsonUnmarshaller() {
    }

    public ContextDataType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        ContextDataType contextDataType = new ContextDataType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("IpAddress")) {
                contextDataType.setIpAddress(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ServerName")) {
                contextDataType.setServerName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ServerPath")) {
                contextDataType.setServerPath(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("HttpHeaders")) {
                contextDataType.setHttpHeaders(new ListUnmarshaller((Unmarshaller)HttpHeaderJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("EncodedData")) {
                contextDataType.setEncodedData(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return contextDataType;
    }

    public static ContextDataTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContextDataTypeJsonUnmarshaller();
        }
        return instance;
    }
}

