/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cognito.clientcontext.datacollection;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.Display;
import android.view.WindowManager;
import com.amazonaws.cognito.clientcontext.datacollection.DataCollector;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class DeviceDataCollector
extends DataCollector {
    private static final String PLATFORM = "ANDROID";
    protected static final String LOCAL_STORAGE_PATH = "AWS.Cognito.ContextData";
    protected static final String LOCAL_STORAGE_DEVICE_ID_KEY = "CognitoDeviceId";

    @Override
    public Map<String, String> collect(Context context) {
        HashMap<String, String> contextdata = new HashMap<String, String>();
        contextdata.put("ClientTimezone", this.getTimezoneOffset());
        contextdata.put("Platform", PLATFORM);
        contextdata.put("ThirdPartyDeviceId", this.getThirdPartyDeviceAgent());
        contextdata.put("DeviceId", this.getCognitoDeviceAgent(context));
        contextdata.put("DeviceLanguage", this.getLanguage());
        Display display = this.getDisplay(context);
        contextdata.put("ScreenHeightPixels", String.valueOf(display.getHeight()));
        contextdata.put("ScreenWidthPixels", String.valueOf(display.getWidth()));
        return contextdata;
    }

    private Display getDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    protected String getCognitoDeviceAgent(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(LOCAL_STORAGE_PATH, 0);
        if (sharedPreferences == null) {
            return null;
        }
        String storedId = sharedPreferences.getString(LOCAL_STORAGE_DEVICE_ID_KEY, null);
        if (storedId != null) {
            return storedId;
        }
        String randomId = UUID.randomUUID().toString();
        String deviceId = randomId + ":" + new Date().getTime();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(LOCAL_STORAGE_DEVICE_ID_KEY, deviceId);
        editor.apply();
        return deviceId;
    }

    protected String getThirdPartyDeviceAgent() {
        return "android_id";
    }

    protected String getLanguage() {
        return Locale.getDefault().toString();
    }

    private String getTimezoneOffset() {
        TimeZone timeZone = this.getTimezone();
        int rawTimezoneOffset = timeZone.getRawOffset();
        long hours = TimeUnit.MILLISECONDS.toHours(rawTimezoneOffset);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(rawTimezoneOffset) - TimeUnit.HOURS.toMinutes(hours);
        String offset = (hours < 0L ? "-" : "") + String.format(Locale.US, "%02d:%02d", Math.abs(hours), minutes);
        return offset;
    }

    protected TimeZone getTimezone() {
        return TimeZone.getDefault();
    }
}

