/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import java.util.Date;

public final class Record {
    private final String key;
    private final String value;
    private final long syncCount;
    private final Date lastModifiedDate;
    private final String lastModifiedBy;
    private final Date deviceLastModifiedDate;
    private final boolean modified;

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public long getSyncCount() {
        return this.syncCount;
    }

    public Date getLastModifiedDate() {
        return new Date(this.lastModifiedDate.getTime());
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Date getDeviceLastModifiedDate() {
        return new Date(this.deviceLastModifiedDate.getTime());
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isDeleted() {
        return this.value == null;
    }

    private Record(Builder builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.lastModifiedDate = builder.lastModifiedDate == null ? new Date() : new Date(builder.lastModifiedDate.getTime());
        this.lastModifiedBy = builder.lastModifiedBy;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate == null ? new Date() : new Date(builder.deviceLastModifiedDate.getTime());
        this.modified = builder.modified;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("key:[").append(this.key).append("],").append("value:[").append(this.value).append("],").append("sync_count:[").append(this.syncCount).append("],").append("last_modified_date:[").append(this.lastModifiedDate).append("],").append("last_modified_by:[").append(this.lastModifiedBy).append("],").append("device_last_modified_date:[").append(this.deviceLastModifiedDate).append("],").append("last_modified_by:[").append(this.lastModifiedBy).append("],").append("is_modified:[").append(this.modified).append("]");
        return sb.toString();
    }

    public static final class Builder {
        private final String key;
        private String value;
        private long syncCount;
        private Date lastModifiedDate;
        private String lastModifiedBy;
        private Date deviceLastModifiedDate;
        private boolean modified;

        public Builder(String key) {
            if (StringUtils.isEmpty(key)) {
                throw new IllegalArgumentException("key can't be empty");
            }
            this.key = key;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder syncCount(long syncCount) {
            if (syncCount < 0L) {
                throw new IllegalArgumentException("sync count can't be negative");
            }
            this.syncCount = syncCount;
            return this;
        }

        public Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Builder deviceLastModifiedDate(Date deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public Builder modified(boolean modified) {
            this.modified = modified;
            return this;
        }

        public Record build() {
            return new Record(this);
        }
    }
}

