/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito.internal.storage;

import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataAccessNotAuthorizedException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataConflictException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataLimitExceededException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DatasetNotFoundException;
import com.amazonaws.mobileconnectors.cognito.exceptions.NetworkException;
import com.amazonaws.mobileconnectors.cognito.exceptions.SubscribeFailedException;
import com.amazonaws.mobileconnectors.cognito.exceptions.UnsubscribeFailedException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.RemoteDataStorage;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitosync.AmazonCognitoSync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.Dataset;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.LimitExceededException;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.NotAuthorizedException;
import com.amazonaws.services.cognitosync.model.Operation;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.ResourceConflictException;
import com.amazonaws.services.cognitosync.model.ResourceNotFoundException;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Deprecated
public class CognitoSyncStorage
implements RemoteDataStorage {
    private static final String TAG = "CognitoSyncStorage";
    private final String identityPoolId;
    private final AmazonCognitoSync client;
    private final CognitoCachingCredentialsProvider provider;
    private String userAgent;

    public CognitoSyncStorage(String identityPoolId, AmazonCognitoSync client, CognitoCachingCredentialsProvider provider) {
        this.identityPoolId = identityPoolId;
        this.client = client;
        this.provider = provider;
        this.userAgent = "";
    }

    @Deprecated
    public CognitoSyncStorage(String identityPoolId, Regions region, CognitoCachingCredentialsProvider provider) {
        this.identityPoolId = identityPoolId;
        this.provider = provider;
        this.client = new AmazonCognitoSyncClient((AWSCredentialsProvider)provider);
        this.client.setRegion(Region.getRegion((Regions)region));
        this.userAgent = "";
    }

    @Override
    public List<DatasetMetadata> getDatasets() {
        ListDatasetsResult result;
        ArrayList<DatasetMetadata> datasets = new ArrayList<DatasetMetadata>();
        String nextToken = null;
        do {
            ListDatasetsRequest request = new ListDatasetsRequest();
            this.appendUserAgent(request, this.userAgent);
            request.setIdentityPoolId(this.identityPoolId);
            request.setMaxResults(64);
            request.setNextToken(nextToken);
            result = null;
            try {
                request.setIdentityId(this.getIdentityId());
                result = this.client.listDatasets(request);
            }
            catch (AmazonClientException ace) {
                throw this.handleException(ace, "Failed to list dataset metadata");
            }
            for (Dataset dataset : result.getDatasets()) {
                datasets.add(this.modelToDatasetMetadata(dataset));
            }
        } while ((nextToken = result.getNextToken()) != null);
        return datasets;
    }

    @Override
    public RemoteDataStorage.DatasetUpdates listUpdates(String datasetName, long lastSyncCount) {
        ListRecordsResult result;
        DatasetUpdatesImpl.Builder builder = new DatasetUpdatesImpl.Builder(datasetName);
        String nextToken = null;
        do {
            ListRecordsRequest request = new ListRecordsRequest();
            this.appendUserAgent(request, this.userAgent);
            request.setIdentityPoolId(this.identityPoolId);
            request.setDatasetName(datasetName);
            request.setLastSyncCount(lastSyncCount);
            request.setMaxResults(1024);
            request.setNextToken(nextToken);
            result = null;
            try {
                request.setIdentityId(this.getIdentityId());
                result = this.client.listRecords(request);
            }
            catch (AmazonClientException ace) {
                throw this.handleException(ace, "Failed to list records in dataset: " + datasetName);
            }
            for (com.amazonaws.services.cognitosync.model.Record remoteRecord : result.getRecords()) {
                builder.addRecord(this.modelToRecord(remoteRecord));
            }
            builder.syncSessionToken(result.getSyncSessionToken()).syncCount(result.getDatasetSyncCount()).exists(result.isDatasetExists()).deleted(result.isDatasetDeletedAfterRequestedSyncCount()).mergedDatasetNameList(result.getMergedDatasetNames());
        } while ((nextToken = result.getNextToken()) != null);
        return builder.build();
    }

    @Override
    public List<Record> putRecords(String datasetName, List<Record> records, String syncSessionToken, String deviceId) {
        UpdateRecordsRequest request = new UpdateRecordsRequest();
        this.appendUserAgent(request, this.userAgent);
        request.setDatasetName(datasetName);
        request.setIdentityPoolId(this.identityPoolId);
        request.setDeviceId(deviceId);
        request.setSyncSessionToken(syncSessionToken);
        ArrayList<RecordPatch> patches = new ArrayList<RecordPatch>();
        for (Record record : records) {
            patches.add(this.recordToPatch(record));
        }
        request.setRecordPatches(patches);
        ArrayList<Record> updatedRecords = new ArrayList<Record>();
        try {
            request.setIdentityId(this.getIdentityId());
            UpdateRecordsResult result = this.client.updateRecords(request);
            for (com.amazonaws.services.cognitosync.model.Record remoteRecord : result.getRecords()) {
                updatedRecords.add(this.modelToRecord(remoteRecord));
            }
        }
        catch (AmazonClientException ace) {
            throw this.handleException(ace, "Failed to update records in dataset: " + datasetName);
        }
        return updatedRecords;
    }

    @Override
    public void deleteDataset(String datasetName) {
        DeleteDatasetRequest request = new DeleteDatasetRequest();
        this.appendUserAgent(request, this.userAgent);
        request.setIdentityPoolId(this.identityPoolId);
        request.setDatasetName(datasetName);
        try {
            request.setIdentityId(this.getIdentityId());
            this.client.deleteDataset(request);
        }
        catch (AmazonClientException ace) {
            throw this.handleException(ace, "Failed to delete dataset: " + datasetName);
        }
    }

    RecordPatch recordToPatch(Record record) {
        RecordPatch patch = new RecordPatch();
        patch.setKey(record.getKey());
        patch.setValue(record.getValue());
        patch.setSyncCount(record.getSyncCount());
        patch.setOp(record.getValue() == null ? Operation.Remove : Operation.Replace);
        if (record.getDeviceLastModifiedDate() != null) {
            patch.setDeviceLastModifiedDate(record.getDeviceLastModifiedDate());
        }
        return patch;
    }

    Record modelToRecord(com.amazonaws.services.cognitosync.model.Record model) {
        return new Record.Builder(model.getKey()).value(model.getValue()).syncCount(model.getSyncCount() == null ? 0L : model.getSyncCount()).lastModifiedBy(model.getLastModifiedBy()).lastModifiedDate(model.getLastModifiedDate() == null ? new Date(0L) : model.getLastModifiedDate()).deviceLastModifiedDate(model.getDeviceLastModifiedDate() == null ? new Date(0L) : model.getDeviceLastModifiedDate()).modified(false).build();
    }

    @Override
    public DatasetMetadata getDatasetMetadata(String datasetName) throws DataStorageException {
        DescribeDatasetRequest request = new DescribeDatasetRequest();
        this.appendUserAgent(request, this.userAgent);
        request.setIdentityPoolId(this.identityPoolId);
        DatasetMetadata dataset = null;
        try {
            request.setIdentityId(this.getIdentityId());
            request.setDatasetName(datasetName);
            DescribeDatasetResult result = this.client.describeDataset(request);
            dataset = this.modelToDatasetMetadata(result.getDataset());
        }
        catch (AmazonClientException ace) {
            throw this.handleException(ace, "Failed to get metadata of dataset: " + datasetName);
        }
        return dataset;
    }

    DataStorageException handleException(AmazonClientException ace, String message) {
        if (ace instanceof ResourceNotFoundException) {
            return new DatasetNotFoundException(message);
        }
        if (ace instanceof ResourceConflictException) {
            return new DataConflictException(message);
        }
        if (ace instanceof LimitExceededException) {
            return new DataLimitExceededException(message);
        }
        if (ace instanceof NotAuthorizedException) {
            return new DataAccessNotAuthorizedException(message);
        }
        if (this.isNetworkException(ace)) {
            return new NetworkException(message);
        }
        return new DataStorageException(message, ace);
    }

    String getIdentityId() throws AmazonClientException, NotAuthorizedException {
        return this.provider.getIdentityId();
    }

    boolean isNetworkException(AmazonClientException ace) {
        return ace.getCause() instanceof IOException;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    void appendUserAgent(AmazonWebServiceRequest request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
    }

    @Override
    public void unsubscribeFromDataset(String datasetName, String deviceId) {
        String identityId = this.provider.getIdentityId();
        UnsubscribeFromDatasetRequest request = new UnsubscribeFromDatasetRequest().withIdentityPoolId(this.provider.getIdentityPoolId()).withIdentityId(identityId).withDatasetName(datasetName).withDeviceId(deviceId);
        try {
            this.client.unsubscribeFromDataset(request);
        }
        catch (AmazonClientException ace) {
            Log.e((String)TAG, (String)"Failed to unsubscribe from dataset", (Throwable)ace);
            throw new UnsubscribeFailedException("Failed to unsubscribe from dataset", ace);
        }
    }

    @Override
    public void subscribeToDataset(String datasetName, String deviceId) {
        String identityId = this.provider.getIdentityId();
        SubscribeToDatasetRequest request = new SubscribeToDatasetRequest().withIdentityPoolId(this.provider.getIdentityPoolId()).withIdentityId(identityId).withDatasetName(datasetName).withDeviceId(deviceId);
        try {
            this.client.subscribeToDataset(request);
        }
        catch (AmazonClientException ace) {
            Log.e((String)TAG, (String)"Failed to subscribe to dataset", (Throwable)ace);
            throw new SubscribeFailedException("Failed to subscribe to dataset", ace);
        }
    }

    private DatasetMetadata modelToDatasetMetadata(Dataset model) {
        return new DatasetMetadata.Builder(model.getDatasetName()).creationDate(model.getCreationDate()).lastModifiedDate(model.getLastModifiedDate()).lastModifiedBy(model.getLastModifiedBy()).storageSizeBytes(model.getDataStorage()).recordCount(model.getNumRecords()).build();
    }

    static class DatasetUpdatesImpl
    implements RemoteDataStorage.DatasetUpdates {
        private final String datasetName;
        private final List<Record> records;
        private final long syncCount;
        private final String syncSessionToken;
        private final boolean exists;
        private final boolean deleted;
        private final List<String> mergedDatasetNameList;

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public List<Record> getRecords() {
            return this.records;
        }

        @Override
        public long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        @Override
        public List<String> getMergedDatasetNameList() {
            return this.mergedDatasetNameList;
        }

        private DatasetUpdatesImpl(Builder builder) {
            this.datasetName = builder.datasetName;
            this.records = builder.records;
            this.syncCount = builder.syncCount;
            this.syncSessionToken = builder.syncSessionToken;
            this.exists = builder.exists;
            this.deleted = builder.deleted;
            this.mergedDatasetNameList = builder.mergedDatasetNameList;
        }

        static class Builder {
            private final String datasetName;
            private final List<Record> records = new ArrayList<Record>();
            private long syncCount = 0L;
            private String syncSessionToken;
            private boolean exists = true;
            private boolean deleted = false;
            private final List<String> mergedDatasetNameList = new ArrayList<String>();

            Builder(String datasetName) {
                this.datasetName = datasetName;
            }

            Builder syncSessionToken(String syncSessionToken) {
                this.syncSessionToken = syncSessionToken;
                return this;
            }

            Builder syncCount(long syncCount) {
                this.syncCount = syncCount;
                return this;
            }

            Builder exists(boolean exists) {
                this.exists = exists;
                return this;
            }

            Builder deleted(boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            Builder addRecord(Record record) {
                this.records.add(record);
                return this;
            }

            Builder mergedDatasetNameList(List<String> mergedDatasetNameList) {
                if (mergedDatasetNameList != null) {
                    this.mergedDatasetNameList.addAll(mergedDatasetNameList);
                }
                return this;
            }

            RemoteDataStorage.DatasetUpdates build() {
                return new DatasetUpdatesImpl(this);
            }
        }
    }
}

