/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.Dataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDatasetsResult
implements Serializable {
    private ListWithAutoConstructFlag<Dataset> datasets;
    private Integer count;
    private String nextToken;

    public List<Dataset> getDatasets() {
        if (this.datasets == null) {
            this.datasets = new ListWithAutoConstructFlag();
            this.datasets.setAutoConstruct(true);
        }
        return this.datasets;
    }

    public void setDatasets(Collection<Dataset> datasets) {
        if (datasets == null) {
            this.datasets = null;
            return;
        }
        ListWithAutoConstructFlag datasetsCopy = new ListWithAutoConstructFlag(datasets.size());
        datasetsCopy.addAll(datasets);
        this.datasets = datasetsCopy;
    }

    public ListDatasetsResult withDatasets(Dataset ... datasets) {
        if (this.getDatasets() == null) {
            this.setDatasets(new ArrayList<Dataset>(datasets.length));
        }
        for (Dataset value : datasets) {
            this.getDatasets().add(value);
        }
        return this;
    }

    public ListDatasetsResult withDatasets(Collection<Dataset> datasets) {
        if (datasets == null) {
            this.datasets = null;
        } else {
            ListWithAutoConstructFlag datasetsCopy = new ListWithAutoConstructFlag(datasets.size());
            datasetsCopy.addAll(datasets);
            this.datasets = datasetsCopy;
        }
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public ListDatasetsResult withCount(Integer count) {
        this.count = count;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDatasetsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasets() != null) {
            sb.append("Datasets: " + this.getDatasets() + ",");
        }
        if (this.getCount() != null) {
            sb.append("Count: " + this.getCount() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasets() == null ? 0 : ((Object)this.getDatasets()).hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResult)) {
            return false;
        }
        ListDatasetsResult other = (ListDatasetsResult)obj;
        if (other.getDatasets() == null ^ this.getDatasets() == null) {
            return false;
        }
        if (other.getDatasets() != null && !((Object)other.getDatasets()).equals(this.getDatasets())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

