/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito.internal.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.LocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLiteLocalStorage
implements LocalStorage {
    private static final String TAG = "SQLiteLocalStorage";
    static final String TABLE_DATASETS = "datasets";
    static final String TABLE_RECORDS = "records";
    private final DatabaseHelper helper;

    public SQLiteLocalStorage(Context context, String databaseName) {
        this.helper = new DatabaseHelper(context, databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataset(String identityId, String datasetName) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            DatasetMetadata metadata = this.getMetadataInternal(db, identityId, datasetName);
            if (metadata == null) {
                ContentValues values = new ContentValues();
                values.put("identity_id", identityId);
                values.put("dataset_name", datasetName);
                values.put("creation_timestamp", String.valueOf(new Date().getTime()));
                values.put("last_modified_timestamp", String.valueOf(new Date().getTime()));
                long row = db.insert(TABLE_DATASETS, null, values);
                if (row == -1L) {
                    Log.e((String)TAG, (String)String.format("couldn't create dataset %s", datasetName));
                }
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    @Override
    public String getValue(String identityId, String datasetName, String key) {
        Record record = this.getRecord(identityId, datasetName, key);
        if (record == null) {
            return null;
        }
        return record.getValue();
    }

    @Override
    public void putValue(String identityId, String datasetName, String key, String value) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        boolean result = this.putValueInternal(db, identityId, datasetName, key, value);
        if (!result) {
            Log.e((String)TAG, (String)String.format("failed to put record [%s: %s] into dataset %s", key, value, datasetName));
        } else {
            this.updateLastModifiedTimestamp(db, identityId, datasetName);
        }
    }

    @Override
    public Map<String, String> getValueMap(String identityId, String datasetName) {
        HashMap<String, String> values = new HashMap<String, String>();
        List<Record> records = this.getRecords(identityId, datasetName);
        for (Record record : records) {
            if (record.isDeleted()) continue;
            values.put(record.getKey(), record.getValue());
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAllValues(String identityId, String datasetName, Map<String, String> values) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                this.putValueInternal(db, identityId, datasetName, entry.getKey(), entry.getValue());
            }
            this.updateLastModifiedTimestamp(db, identityId, datasetName);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    boolean putValueInternal(SQLiteDatabase db, String identityId, String datasetName, String key, String value) {
        Record record = this.getRecord(identityId, datasetName, key);
        if (record != null && StringUtils.equals(record.getValue(), value)) {
            return true;
        }
        ContentValues values = new ContentValues();
        values.put("identity_id", identityId);
        values.put("dataset_name", datasetName);
        values.put("key", key);
        values.put("value", value);
        values.put("modified", Boolean.valueOf(true));
        values.put("sync_count", Long.valueOf(record == null ? 0L : record.getSyncCount()));
        values.put("device_last_modified_timestamp", String.valueOf(new Date().getTime()));
        if (record == null) {
            return db.insert(TABLE_RECORDS, null, values) != -1L;
        }
        return db.update(TABLE_RECORDS, values, "identity_id = ? AND dataset_name = ? AND key = ?", new String[]{identityId, datasetName, key}) == 1;
    }

    @Override
    public List<DatasetMetadata> getDatasets(String identityId) {
        ArrayList<DatasetMetadata> datasets = new ArrayList<DatasetMetadata>();
        SQLiteDatabase db = this.helper.getWritableDatabase();
        Cursor c = db.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ?", new String[]{identityId}, null, null, null);
        while (c.moveToNext()) {
            datasets.add(this.cursorToDatasetMetadata(c));
        }
        c.close();
        return datasets;
    }

    @Override
    public DatasetMetadata getDatasetMetadata(String identityId, String datasetName) throws DataStorageException {
        DatasetMetadata dataset = null;
        SQLiteDatabase db = this.helper.getWritableDatabase();
        Cursor c = db.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName}, null, null, null);
        if (c.moveToFirst()) {
            dataset = this.cursorToDatasetMetadata(c);
        }
        c.close();
        return dataset;
    }

    DatasetMetadata cursorToDatasetMetadata(Cursor c) {
        String datasetName = c.getString(c.getColumnIndex("dataset_name"));
        return new DatasetMetadata.Builder(datasetName).creationDate(new Date(c.getLong(c.getColumnIndex("creation_timestamp")))).lastModifiedDate(new Date(c.getLong(c.getColumnIndex("last_modified_timestamp")))).lastModifiedBy(c.getString(c.getColumnIndex("last_modified_by"))).storageSizeBytes(c.getLong(c.getColumnIndex("storage_size_bytes"))).recordCount(c.getLong(c.getColumnIndex("record_count"))).build();
    }

    @Override
    public Record getRecord(String identityId, String datasetName, String key) {
        Record record = null;
        SQLiteDatabase db = this.helper.getWritableDatabase();
        Cursor c = db.query(TABLE_RECORDS, RecordColumns.ALL, "identity_id = ? AND dataset_name = ? AND key = ?", new String[]{identityId, datasetName, key}, null, null, null);
        if (c.moveToFirst()) {
            record = this.cursorToRecord(c);
        }
        c.close();
        return record;
    }

    @Override
    public List<Record> getRecords(String identityId, String datasetName) {
        ArrayList<Record> records = new ArrayList<Record>();
        SQLiteDatabase db = this.helper.getWritableDatabase();
        Cursor c = db.query(TABLE_RECORDS, RecordColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName}, null, null, null);
        while (c.moveToNext()) {
            records.add(this.cursorToRecord(c));
        }
        c.close();
        return records;
    }

    Record cursorToRecord(Cursor c) {
        return new Record.Builder(c.getString(c.getColumnIndex("key"))).value(c.getString(c.getColumnIndex("value"))).syncCount(c.getLong(c.getColumnIndex("sync_count"))).deviceLastModifiedDate(new Date(c.getLong(c.getColumnIndex("device_last_modified_timestamp")))).lastModifiedDate(new Date(c.getLong(c.getColumnIndex("last_modified_timestamp")))).lastModifiedBy(c.getString(c.getColumnIndex("last_modified_by"))).modified(c.getInt(c.getColumnIndex("modified")) == 1).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putRecords(String identityId, String datasetName, List<Record> records) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            for (Record record : records) {
                this.updateAndClearRecord(db, identityId, datasetName, record);
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataset(String identityId, String datasetName) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            int rows = db.delete(TABLE_RECORDS, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName});
            Log.i((String)TAG, (String)String.format("%d records were deleted from dataset %s", rows, datasetName));
            ContentValues values = new ContentValues();
            values.put("last_modified_timestamp", Long.valueOf(System.currentTimeMillis()));
            values.put("last_sync_count", String.valueOf(-1));
            rows = db.update(TABLE_DATASETS, values, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName});
            if (rows != 1) {
                Log.e((String)TAG, (String)String.format("couldn't mark dataset %s deleted", datasetName));
            } else {
                db.setTransactionSuccessful();
            }
        }
        finally {
            db.endTransaction();
        }
    }

    @Override
    public void purgeDataset(String identityId, String datasetName) {
        this.deleteDataset(identityId, datasetName);
        SQLiteDatabase db = this.helper.getWritableDatabase();
        int rows = db.delete(TABLE_DATASETS, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName});
        if (rows != 1) {
            Log.e((String)TAG, (String)String.format("failed to purge dataset %s", datasetName));
        }
    }

    @Override
    public long getLastSyncCount(String identityId, String datasetName) {
        long lastSyncCount = 0L;
        SQLiteDatabase db = this.helper.getWritableDatabase();
        Cursor c = db.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName}, null, null, null);
        if (c.moveToFirst()) {
            lastSyncCount = c.getInt(c.getColumnIndex("last_sync_count"));
        } else {
            Log.w((String)TAG, (String)String.format("couldn't find %s in %s table", datasetName, TABLE_DATASETS));
        }
        c.close();
        return lastSyncCount;
    }

    @Override
    public List<Record> getModifiedRecords(String identityId, String datasetName) {
        ArrayList<Record> records = new ArrayList<Record>();
        SQLiteDatabase db = this.helper.getWritableDatabase();
        Cursor c = db.query(TABLE_RECORDS, RecordColumns.ALL, "identity_id = ? AND dataset_name = ? AND modified = ?", new String[]{identityId, datasetName, String.valueOf(1)}, null, null, null);
        while (c.moveToNext()) {
            records.add(this.cursorToRecord(c));
        }
        c.close();
        return records;
    }

    public void close() {
        this.helper.close();
    }

    @Override
    public void updateLastSyncCount(String identityId, String datasetName, long lastSyncCount) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("last_sync_count", Long.valueOf(lastSyncCount));
        values.put("last_sync_timestamp", Long.valueOf(System.currentTimeMillis()));
        int rows = db.update(TABLE_DATASETS, values, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName});
        if (rows != 1) {
            Log.e((String)TAG, (String)String.format("failed to update last sync count of dataset %s", datasetName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeData() {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            db.execSQL("DELETE FROM datasets");
            db.execSQL("DELETE FROM records");
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    void updateLastModifiedTimestamp(SQLiteDatabase db, String identityId, String datasetName) {
        ContentValues values = new ContentValues();
        values.put("last_modified_timestamp", Long.valueOf(System.currentTimeMillis()));
        int rows = db.update(TABLE_DATASETS, values, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName});
        if (rows != 1) {
            Log.w((String)TAG, (String)String.format("failed to update last modified timestamp of dataset %s", datasetName));
        }
    }

    void removeRecord(SQLiteDatabase db, String identityId, String datasetName, Record record) {
        int rows = db.delete(TABLE_RECORDS, "identity_id = ? AND dataset_name = ? AND key = ?", new String[]{identityId, datasetName, record.getKey()});
        if (rows == 0) {
            Log.w((String)TAG, (String)String.format("failed to delete record %s from dataset %s", record.getKey(), datasetName));
        }
    }

    void updateAndClearRecord(SQLiteDatabase db, String identityId, String datasetName, Record record) {
        ContentValues values = new ContentValues();
        values.put("identity_id", identityId);
        values.put("dataset_name", datasetName);
        values.put("key", record.getKey());
        values.put("value", record.getValue());
        values.put("sync_count", Long.valueOf(record.getSyncCount()));
        values.put("modified", Boolean.valueOf(record.isModified()));
        long row = db.replace(TABLE_RECORDS, null, values);
        if (row == -1L) {
            Log.e((String)TAG, (String)String.format("failed to store record [%s: %s] into dataset %s", record.getKey(), record.getValue(), datasetName));
        }
    }

    Set<String> getCommonDatasetNames(String oldIdentityId, String newIdentityId) {
        HashSet<String> newNameSet = new HashSet<String>();
        HashSet<String> oldNameSet = new HashSet<String>();
        if (oldIdentityId != null && newIdentityId != null) {
            List<DatasetMetadata> newDatasets = this.getDatasets(newIdentityId);
            List<DatasetMetadata> oldDatasets = this.getDatasets(oldIdentityId);
            for (DatasetMetadata oldMetaData : oldDatasets) {
                oldNameSet.add(oldMetaData.getDatasetName());
            }
            for (DatasetMetadata newMetaData : newDatasets) {
                newNameSet.add(newMetaData.getDatasetName());
            }
            oldNameSet.retainAll(newNameSet);
        }
        return oldNameSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void changeIdentityId(String oldIdentityId, String newIdentityId) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            if ("unknown".equals(oldIdentityId)) {
                Set<String> commonDatasetNames = this.getCommonDatasetNames(oldIdentityId, newIdentityId);
                if (commonDatasetNames.size() > 0) {
                    for (String oldDatasetName : commonDatasetNames) {
                        db.execSQL("UPDATE datasets SET dataset_name = '" + oldDatasetName + "." + oldIdentityId + "'" + " WHERE " + "identity_id" + " = ?" + " AND " + "dataset_name" + " = ?", (Object[])new String[]{oldIdentityId, oldDatasetName});
                        db.execSQL("UPDATE records SET dataset_name = '" + oldDatasetName + "." + oldIdentityId + "'" + " WHERE " + "identity_id" + " = ?" + " AND " + "dataset_name" + " = ?", (Object[])new String[]{oldIdentityId, oldDatasetName});
                    }
                }
                db.execSQL("UPDATE datasets SET identity_id = '" + newIdentityId + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{oldIdentityId});
                db.execSQL("UPDATE records SET identity_id = '" + newIdentityId + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{oldIdentityId});
            } else {
                db.execSQL("INSERT INTO datasets(identity_id,dataset_name,creation_timestamp,storage_size_bytes,record_count) SELECT '" + newIdentityId + "'," + "dataset_name" + "," + "creation_timestamp" + "," + "storage_size_bytes" + "," + "record_count" + " FROM " + TABLE_DATASETS + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{oldIdentityId});
                db.execSQL("INSERT INTO records(identity_id,dataset_name,key,value,last_modified_timestamp,last_modified_by,device_last_modified_timestamp) SELECT '" + newIdentityId + "'," + "dataset_name" + "," + "key" + "," + "value" + "," + "last_modified_timestamp" + "," + "last_modified_by" + "," + "device_last_modified_timestamp" + " FROM " + TABLE_RECORDS + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{oldIdentityId});
                db.execSQL("UPDATE datasets SET identity_id = '" + newIdentityId + "', " + "dataset_name" + " = " + "dataset_name" + " || '." + oldIdentityId + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{oldIdentityId});
                db.execSQL("UPDATE records SET identity_id = '" + newIdentityId + "', " + "dataset_name" + " = " + "dataset_name" + " || '." + oldIdentityId + "'" + " WHERE " + "identity_id" + " = ?", (Object[])new String[]{oldIdentityId});
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDatasetMetadata(String identityId, List<DatasetMetadata> datasetMetadata) {
        SQLiteDatabase db = this.helper.getWritableDatabase();
        db.beginTransaction();
        try {
            for (DatasetMetadata metadata : datasetMetadata) {
                if (this.updateDatasetMetadataInternal(db, identityId, metadata)) continue;
                Log.w((String)TAG, (String)String.format("couldn't update dataset metadata %s", metadata.getDatasetName()));
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    DatasetMetadata getMetadataInternal(SQLiteDatabase db, String identityId, String datasetName) {
        DatasetMetadata metadata = null;
        Cursor c = db.query(TABLE_DATASETS, DatasetColumns.ALL, "identity_id = ? AND dataset_name = ?", new String[]{identityId, datasetName}, null, null, null);
        if (c.moveToFirst()) {
            metadata = this.cursorToDatasetMetadata(c);
        }
        c.close();
        return metadata;
    }

    boolean updateDatasetMetadataInternal(SQLiteDatabase db, String identityId, DatasetMetadata metadata) {
        DatasetMetadata local = this.getMetadataInternal(db, identityId, metadata.getDatasetName());
        ContentValues values = new ContentValues();
        values.put("identity_id", identityId);
        values.put("dataset_name", metadata.getDatasetName());
        values.put("creation_timestamp", Long.valueOf(metadata.getCreationDate().getTime()));
        values.put("last_modified_timestamp", Long.valueOf(metadata.getLastModifiedDate().getTime()));
        values.put("last_modified_by", metadata.getLastModifiedBy());
        values.put("record_count", Long.valueOf(metadata.getRecordCount()));
        values.put("storage_size_bytes", Long.valueOf(metadata.getStorageSizeBytes()));
        if (local == null) {
            return db.insert(TABLE_DATASETS, null, values) != -1L;
        }
        return db.update(TABLE_DATASETS, values, "identity_id = ? AND dataset_name = ?", new String[]{identityId, metadata.getDatasetName()}) == 1;
    }

    private class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final int DB_VERSION = 2;

        public DatabaseHelper(Context context, String cognitoId) {
            super(context.getApplicationContext(), cognitoId, null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE datasets(identity_id TEXT NOT NULL,dataset_name TEXT NOT NULL,creation_timestamp INTEGER DEFAULT 0,last_modified_timestamp INTEGER DEFAULT 0,last_modified_by TEXT,storage_size_bytes INTEGER DEFAULT 0,record_count INTEGER DEFAULT 0,last_sync_count INTEGER NOT NULL DEFAULT 0,last_sync_timestamp INTEGER DEFAULT 0,last_sync_result TEXT,UNIQUE (identity_id, dataset_name))");
            db.execSQL("CREATE TABLE records(identity_id TEXT NOT NULL,dataset_name TEXT NOT NULL,key TEXT NOT NULL,value TEXT,sync_count INTEGER NOT NULL DEFAULT 0,last_modified_timestamp INTEGER DEFAULT 0,last_modified_by TEXT,device_last_modified_timestamp INTEGER DEFAULT 0,modified INTEGER NOT NULL DEFAULT 1,UNIQUE (identity_id, dataset_name, key))");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w((String)SQLiteLocalStorage.TAG, (String)"Upgrading database; wiping all data");
            db.execSQL("DROP TABLE IF EXISTS datasets");
            db.execSQL("DROP TABLE IF EXISTS records");
            this.onCreate(db);
        }
    }

    static class RecordColumns {
        static final String IDENTITY_ID = "identity_id";
        static final String DATASET_NAME = "dataset_name";
        static final String KEY = "key";
        static final String VALUE = "value";
        static final String SYNC_COUNT = "sync_count";
        static final String LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
        static final String LAST_MODIFIED_BY = "last_modified_by";
        static final String DEVICE_LAST_MODIFIED_TIMESTAMP = "device_last_modified_timestamp";
        static final String MODIFIED = "modified";
        static final String[] ALL = new String[]{"identity_id", "dataset_name", "key", "value", "sync_count", "last_modified_timestamp", "last_modified_by", "device_last_modified_timestamp", "modified"};

        RecordColumns() {
        }
    }

    static class DatasetColumns {
        static final String IDENTITY_ID = "identity_id";
        static final String DATASET_NAME = "dataset_name";
        static final String CREATION_TIMESTAMP = "creation_timestamp";
        static final String LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
        static final String LAST_MODIFIED_BY = "last_modified_by";
        static final String STORAGE_SIZE_BYTES = "storage_size_bytes";
        static final String RECORD_COUNT = "record_count";
        static final String LAST_SYNC_COUNT = "last_sync_count";
        static final String LAST_SYNC_TIMESTAMP = "last_sync_timestamp";
        static final String LAST_SYNC_RESULT = "last_sync_result";
        static final String[] ALL = new String[]{"identity_id", "dataset_name", "creation_timestamp", "last_modified_timestamp", "last_modified_by", "storage_size_bytes", "record_count", "last_sync_count", "last_sync_timestamp", "last_sync_result"};

        DatasetColumns() {
        }
    }
}

