/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.SyncConflict;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataConflictException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.exceptions.NetworkException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.LocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.storage.RemoteDataStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.DatasetUtils;
import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DefaultDataset
implements Dataset {
    private static final String TAG = "DefaultDataset";
    private static final int MAX_RETRY = 3;
    private final Context context;
    private final String datasetName;
    private final LocalStorage local;
    private final RemoteDataStorage remote;
    private final CognitoCachingCredentialsProvider provider;
    private SyncOnConnectivity pendingSyncRequest = null;

    public DefaultDataset(Context context, String datasetName, CognitoCachingCredentialsProvider provider, LocalStorage local, RemoteDataStorage remote) {
        this.context = context;
        this.datasetName = datasetName;
        this.provider = provider;
        this.local = local;
        this.remote = remote;
    }

    @Override
    public void put(String key, String value) {
        this.local.putValue(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(key), value);
    }

    @Override
    public void remove(String key) {
        this.local.putValue(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(key), null);
    }

    @Override
    public String get(String key) {
        return this.local.getValue(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(key));
    }

    @Override
    public void synchronize(final Dataset.SyncCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback can't ben null");
        }
        if (!DefaultDataset.isNetworkAvailable(this.context)) {
            callback.onFailure(new NetworkException("Network connectivity unavailable."));
            return;
        }
        this.discardPendingSyncRequest();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.d((String)DefaultDataset.TAG, (String)("start to synchronize " + DefaultDataset.this.datasetName));
                boolean result = false;
                try {
                    List<String> mergedDatasets = DefaultDataset.this.getLocalMergedDatasets();
                    if (!mergedDatasets.isEmpty()) {
                        Log.i((String)DefaultDataset.TAG, (String)("detected merge datasets " + DefaultDataset.this.datasetName));
                        callback.onDatasetsMerged(DefaultDataset.this, mergedDatasets);
                    }
                    result = DefaultDataset.this.synchronizeInternal(callback, 3);
                }
                catch (Exception e) {
                    callback.onFailure(new DataStorageException("Unknown exception", e));
                }
                if (result) {
                    Log.d((String)DefaultDataset.TAG, (String)("successfully synchronize " + DefaultDataset.this.datasetName));
                } else {
                    Log.d((String)DefaultDataset.TAG, (String)("failed to synchronize " + DefaultDataset.this.datasetName));
                }
            }
        }).start();
    }

    synchronized boolean synchronizeInternal(Dataset.SyncCallback callback, int retry) {
        List<Record> localChanges;
        if (retry < 0) {
            Log.e((String)TAG, (String)"synchronize failed because it exceeds maximum retry");
            return false;
        }
        long lastSyncCount = this.local.getLastSyncCount(this.getIdentityId(), this.datasetName);
        if (lastSyncCount == -1L) {
            try {
                this.remote.deleteDataset(this.datasetName);
                this.local.purgeDataset(this.getIdentityId(), this.datasetName);
                callback.onSuccess(this, Collections.<Record>emptyList());
                return true;
            }
            catch (DataStorageException dse) {
                callback.onFailure(dse);
                return false;
            }
        }
        Log.d((String)TAG, (String)("get latest modified records since " + lastSyncCount));
        RemoteDataStorage.DatasetUpdates datasetUpdates = null;
        try {
            datasetUpdates = this.remote.listUpdates(this.datasetName, lastSyncCount);
        }
        catch (DataStorageException e) {
            callback.onFailure(e);
            return false;
        }
        if (!datasetUpdates.getMergedDatasetNameList().isEmpty()) {
            boolean resume = callback.onDatasetsMerged(this, new ArrayList<String>(datasetUpdates.getMergedDatasetNameList()));
            if (resume) {
                return this.synchronizeInternal(callback, --retry);
            }
            callback.onFailure(new DataStorageException("Manual cancel"));
            return false;
        }
        if (lastSyncCount != 0L && !datasetUpdates.isExists() || datasetUpdates.isDeleted()) {
            boolean resume = callback.onDatasetDeleted(this, datasetUpdates.getDatasetName());
            if (resume) {
                this.local.deleteDataset(this.getIdentityId(), this.datasetName);
                this.local.purgeDataset(this.getIdentityId(), this.datasetName);
                callback.onSuccess(this, Collections.<Record>emptyList());
                return true;
            }
            callback.onFailure(new DataStorageException("Manual cancel"));
            return false;
        }
        List<Record> remoteRecords = datasetUpdates.getRecords();
        lastSyncCount = datasetUpdates.getSyncCount();
        if (!remoteRecords.isEmpty()) {
            ArrayList<SyncConflict> conflicts = new ArrayList<SyncConflict>();
            Iterator<Record> iter = remoteRecords.iterator();
            while (iter.hasNext()) {
                Record remoteRecord = iter.next();
                Record localRecord = this.local.getRecord(this.getIdentityId(), this.datasetName, remoteRecord.getKey());
                if (localRecord == null || !localRecord.isModified() || localRecord.getSyncCount() == remoteRecord.getSyncCount() || StringUtils.equals(localRecord.getValue(), remoteRecord.getValue())) continue;
                conflicts.add(new SyncConflict(remoteRecord, localRecord));
                iter.remove();
            }
            if (!conflicts.isEmpty()) {
                Log.i((String)TAG, (String)String.format("%d records in conflict!", conflicts.size()));
                if (!callback.onConflict(this, conflicts)) {
                    return false;
                }
            }
            if (!remoteRecords.isEmpty()) {
                Log.i((String)TAG, (String)String.format("save %d records to local", remoteRecords.size()));
                this.local.putRecords(this.getIdentityId(), this.datasetName, remoteRecords);
            }
            Log.i((String)TAG, (String)String.format("updated sync count %d", datasetUpdates.getSyncCount()));
            this.local.updateLastSyncCount(this.getIdentityId(), this.datasetName, datasetUpdates.getSyncCount());
        }
        if (!(localChanges = this.getModifiedRecords()).isEmpty()) {
            Log.i((String)TAG, (String)String.format("push %d records to remote", localChanges.size()));
            List<Record> result = null;
            try {
                SharedPreferences sp = this.getSharedPreferences();
                String deviceId = sp.getString("deviceId", null);
                result = this.remote.putRecords(this.datasetName, localChanges, datasetUpdates.getSyncSessionToken(), deviceId);
            }
            catch (DataConflictException dce) {
                Log.i((String)TAG, (String)"conflicts detected when pushing changes to remote.");
                return this.synchronizeInternal(callback, --retry);
            }
            catch (DataStorageException dse) {
                callback.onFailure(dse);
                return false;
            }
            this.local.putRecords(this.getIdentityId(), this.datasetName, result);
            long newSyncCount = 0L;
            for (Record record : result) {
                newSyncCount = newSyncCount < record.getSyncCount() ? record.getSyncCount() : newSyncCount;
            }
            if (newSyncCount == lastSyncCount + 1L) {
                Log.i((String)TAG, (String)String.format("updated sync count %d", newSyncCount));
                this.local.updateLastSyncCount(this.getIdentityId(), this.datasetName, newSyncCount);
            }
        }
        callback.onSuccess(this, remoteRecords);
        return true;
    }

    @Override
    public List<Record> getAllRecords() {
        return this.local.getRecords(this.getIdentityId(), this.datasetName);
    }

    @Override
    public long getTotalSizeInBytes() {
        long size = 0L;
        for (Record record : this.local.getRecords(this.getIdentityId(), this.datasetName)) {
            size += DatasetUtils.computeRecordSize(record);
        }
        return size;
    }

    @Override
    public long getSizeInBytes(String key) {
        return DatasetUtils.computeRecordSize(this.local.getRecord(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(key)));
    }

    @Override
    public boolean isChanged(String key) {
        Record record = this.local.getRecord(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(key));
        return record != null && record.isModified();
    }

    @Override
    public void delete() {
        this.local.deleteDataset(this.getIdentityId(), this.datasetName);
    }

    @Override
    public DatasetMetadata getDatasetMetadata() {
        return this.local.getDatasetMetadata(this.getIdentityId(), this.datasetName);
    }

    @Override
    public void resolve(List<Record> remoteRecords) {
        this.local.putRecords(this.getIdentityId(), this.datasetName, remoteRecords);
    }

    @Override
    public void putAll(Map<String, String> values) {
        for (String key : values.keySet()) {
            DatasetUtils.validateRecordKey(key);
        }
        this.local.putAllValues(this.getIdentityId(), this.datasetName, values);
    }

    @Override
    public Map<String, String> getAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Record record : this.local.getRecords(this.getIdentityId(), this.datasetName)) {
            if (record.isDeleted()) continue;
            map.put(record.getKey(), record.getValue());
        }
        return map;
    }

    String getIdentityId() {
        return DatasetUtils.getIdentityId(this.provider);
    }

    List<Record> getModifiedRecords() {
        return this.local.getModifiedRecords(this.getIdentityId(), this.datasetName);
    }

    List<String> getLocalMergedDatasets() {
        ArrayList<String> mergedDatasets = new ArrayList<String>();
        String prefix = this.datasetName + ".";
        for (DatasetMetadata dataset : this.local.getDatasets(this.getIdentityId())) {
            if (!dataset.getDatasetName().startsWith(prefix)) continue;
            mergedDatasets.add(dataset.getDatasetName());
        }
        return mergedDatasets;
    }

    @Override
    public void synchronizeOnConnectivity(Dataset.SyncCallback callback) {
        if (DefaultDataset.isNetworkAvailable(this.context)) {
            this.synchronize(callback);
        } else {
            this.discardPendingSyncRequest();
            Log.d((String)TAG, (String)"Connectivity is unavailable. Scheduling synchronize for when connectivity is resumed.");
            this.pendingSyncRequest = new SyncOnConnectivity(this, callback);
            this.context.registerReceiver((BroadcastReceiver)this.pendingSyncRequest, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discardPendingSyncRequest() {
        if (this.pendingSyncRequest != null) {
            Log.d((String)TAG, (String)"Discard previous pending sync request");
            DefaultDataset defaultDataset = this;
            synchronized (defaultDataset) {
                try {
                    this.context.unregisterReceiver((BroadcastReceiver)this.pendingSyncRequest);
                }
                catch (IllegalArgumentException e) {
                    Log.d((String)TAG, (String)"SyncOnConnectivity has been unregistered.");
                }
                this.pendingSyncRequest = null;
            }
        }
    }

    static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    @Override
    public long getLastSyncCount() {
        return this.local.getLastSyncCount(this.getIdentityId(), this.datasetName);
    }

    @Override
    public void unsubscribe() {
        String deviceId = this.getSharedPreferences().getString("deviceId", "");
        if (deviceId.isEmpty()) {
            throw new IllegalStateException("Device hasn't been registered yet");
        }
        this.remote.unsubscribeFromDataset(this.datasetName, deviceId);
    }

    @Override
    public void subscribe() {
        String deviceId = this.getSharedPreferences().getString("deviceId", "");
        if (deviceId.isEmpty()) {
            throw new IllegalStateException("Device hasn't been registered yet");
        }
        this.remote.subscribeToDataset(this.datasetName, deviceId);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences("com.amazonaws.mobileconnectors.cognito", 0);
    }

    static class SyncOnConnectivity
    extends BroadcastReceiver {
        WeakReference<Dataset> datasetRef;
        WeakReference<Dataset.SyncCallback> callbackRef;

        SyncOnConnectivity(Dataset dataset, Dataset.SyncCallback callback) {
            this.datasetRef = new WeakReference<Dataset>(dataset);
            this.callbackRef = new WeakReference<Dataset.SyncCallback>(callback);
        }

        public void onReceive(Context context, Intent intent) {
            if (!DefaultDataset.isNetworkAvailable(context)) {
                Log.d((String)DefaultDataset.TAG, (String)"Connectivity is unavailable.");
                return;
            }
            Log.d((String)DefaultDataset.TAG, (String)"Connectivity is available. Try synchronizing.");
            context.unregisterReceiver((BroadcastReceiver)this);
            Dataset dataset = (Dataset)this.datasetRef.get();
            Dataset.SyncCallback callback = (Dataset.SyncCallback)this.callbackRef.get();
            if (dataset == null || callback == null) {
                Log.w((String)DefaultDataset.TAG, (String)"Abort syncOnConnectivity because either dataset or callback was garbage collected");
            } else {
                dataset.synchronize(callback);
            }
        }
    }
}

