/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRecordsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityPoolId;
    private String identityId;
    private String datasetName;
    private ListWithAutoConstructFlag<RecordPatch> recordPatches;
    private String syncSessionToken;
    private String clientContext;

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String string) {
        this.identityPoolId = string;
    }

    public UpdateRecordsRequest withIdentityPoolId(String string) {
        this.identityPoolId = string;
        return this;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String string) {
        this.identityId = string;
    }

    public UpdateRecordsRequest withIdentityId(String string) {
        this.identityId = string;
        return this;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String string) {
        this.datasetName = string;
    }

    public UpdateRecordsRequest withDatasetName(String string) {
        this.datasetName = string;
        return this;
    }

    public List<RecordPatch> getRecordPatches() {
        if (this.recordPatches == null) {
            this.recordPatches = new ListWithAutoConstructFlag();
            this.recordPatches.setAutoConstruct(true);
        }
        return this.recordPatches;
    }

    public void setRecordPatches(Collection<RecordPatch> collection) {
        if (collection == null) {
            this.recordPatches = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.recordPatches = listWithAutoConstructFlag;
    }

    public UpdateRecordsRequest withRecordPatches(RecordPatch ... recordPatchArray) {
        if (this.getRecordPatches() == null) {
            this.setRecordPatches(new ArrayList<RecordPatch>(recordPatchArray.length));
        }
        for (RecordPatch recordPatch : recordPatchArray) {
            this.getRecordPatches().add(recordPatch);
        }
        return this;
    }

    public UpdateRecordsRequest withRecordPatches(Collection<RecordPatch> collection) {
        if (collection == null) {
            this.recordPatches = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.recordPatches = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getSyncSessionToken() {
        return this.syncSessionToken;
    }

    public void setSyncSessionToken(String string) {
        this.syncSessionToken = string;
    }

    public UpdateRecordsRequest withSyncSessionToken(String string) {
        this.syncSessionToken = string;
        return this;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    public void setClientContext(String string) {
        this.clientContext = string;
    }

    public UpdateRecordsRequest withClientContext(String string) {
        this.clientContext = string;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIdentityPoolId() != null) {
            stringBuilder.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentityId() != null) {
            stringBuilder.append("IdentityId: " + this.getIdentityId() + ",");
        }
        if (this.getDatasetName() != null) {
            stringBuilder.append("DatasetName: " + this.getDatasetName() + ",");
        }
        if (this.getRecordPatches() != null) {
            stringBuilder.append("RecordPatches: " + this.getRecordPatches() + ",");
        }
        if (this.getSyncSessionToken() != null) {
            stringBuilder.append("SyncSessionToken: " + this.getSyncSessionToken() + ",");
        }
        if (this.getClientContext() != null) {
            stringBuilder.append("ClientContext: " + this.getClientContext());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        n = 31 * n + (this.getIdentityId() == null ? 0 : this.getIdentityId().hashCode());
        n = 31 * n + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        n = 31 * n + (this.getRecordPatches() == null ? 0 : ((Object)this.getRecordPatches()).hashCode());
        n = 31 * n + (this.getSyncSessionToken() == null ? 0 : this.getSyncSessionToken().hashCode());
        n = 31 * n + (this.getClientContext() == null ? 0 : this.getClientContext().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UpdateRecordsRequest)) {
            return false;
        }
        UpdateRecordsRequest updateRecordsRequest = (UpdateRecordsRequest)object;
        if (updateRecordsRequest.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (updateRecordsRequest.getIdentityPoolId() != null && !updateRecordsRequest.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (updateRecordsRequest.getIdentityId() == null ^ this.getIdentityId() == null) {
            return false;
        }
        if (updateRecordsRequest.getIdentityId() != null && !updateRecordsRequest.getIdentityId().equals(this.getIdentityId())) {
            return false;
        }
        if (updateRecordsRequest.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (updateRecordsRequest.getDatasetName() != null && !updateRecordsRequest.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (updateRecordsRequest.getRecordPatches() == null ^ this.getRecordPatches() == null) {
            return false;
        }
        if (updateRecordsRequest.getRecordPatches() != null && !((Object)updateRecordsRequest.getRecordPatches()).equals(this.getRecordPatches())) {
            return false;
        }
        if (updateRecordsRequest.getSyncSessionToken() == null ^ this.getSyncSessionToken() == null) {
            return false;
        }
        if (updateRecordsRequest.getSyncSessionToken() != null && !updateRecordsRequest.getSyncSessionToken().equals(this.getSyncSessionToken())) {
            return false;
        }
        if (updateRecordsRequest.getClientContext() == null ^ this.getClientContext() == null) {
            return false;
        }
        return updateRecordsRequest.getClientContext() == null || updateRecordsRequest.getClientContext().equals(this.getClientContext());
    }
}

