/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecordsResult
implements Serializable {
    private ListWithAutoConstructFlag<Record> records;
    private String nextToken;
    private Integer count;
    private Long datasetSyncCount;
    private String lastModifiedBy;
    private ListWithAutoConstructFlag<String> mergedDatasetNames;
    private Boolean datasetExists;
    private Boolean datasetDeletedAfterRequestedSyncCount;
    private String syncSessionToken;

    public List<Record> getRecords() {
        if (this.records == null) {
            this.records = new ListWithAutoConstructFlag();
            this.records.setAutoConstruct(true);
        }
        return this.records;
    }

    public void setRecords(Collection<Record> collection) {
        if (collection == null) {
            this.records = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.records = listWithAutoConstructFlag;
    }

    public ListRecordsResult withRecords(Record ... recordArray) {
        if (this.getRecords() == null) {
            this.setRecords(new ArrayList<Record>(recordArray.length));
        }
        for (Record record : recordArray) {
            this.getRecords().add(record);
        }
        return this;
    }

    public ListRecordsResult withRecords(Collection<Record> collection) {
        if (collection == null) {
            this.records = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.records = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String string) {
        this.nextToken = string;
    }

    public ListRecordsResult withNextToken(String string) {
        this.nextToken = string;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer n) {
        this.count = n;
    }

    public ListRecordsResult withCount(Integer n) {
        this.count = n;
        return this;
    }

    public Long getDatasetSyncCount() {
        return this.datasetSyncCount;
    }

    public void setDatasetSyncCount(Long l) {
        this.datasetSyncCount = l;
    }

    public ListRecordsResult withDatasetSyncCount(Long l) {
        this.datasetSyncCount = l;
        return this;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String string) {
        this.lastModifiedBy = string;
    }

    public ListRecordsResult withLastModifiedBy(String string) {
        this.lastModifiedBy = string;
        return this;
    }

    public List<String> getMergedDatasetNames() {
        if (this.mergedDatasetNames == null) {
            this.mergedDatasetNames = new ListWithAutoConstructFlag();
            this.mergedDatasetNames.setAutoConstruct(true);
        }
        return this.mergedDatasetNames;
    }

    public void setMergedDatasetNames(Collection<String> collection) {
        if (collection == null) {
            this.mergedDatasetNames = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.mergedDatasetNames = listWithAutoConstructFlag;
    }

    public ListRecordsResult withMergedDatasetNames(String ... stringArray) {
        if (this.getMergedDatasetNames() == null) {
            this.setMergedDatasetNames(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getMergedDatasetNames().add(string);
        }
        return this;
    }

    public ListRecordsResult withMergedDatasetNames(Collection<String> collection) {
        if (collection == null) {
            this.mergedDatasetNames = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.mergedDatasetNames = listWithAutoConstructFlag;
        }
        return this;
    }

    public Boolean isDatasetExists() {
        return this.datasetExists;
    }

    public void setDatasetExists(Boolean bl) {
        this.datasetExists = bl;
    }

    public ListRecordsResult withDatasetExists(Boolean bl) {
        this.datasetExists = bl;
        return this;
    }

    public Boolean getDatasetExists() {
        return this.datasetExists;
    }

    public Boolean isDatasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public void setDatasetDeletedAfterRequestedSyncCount(Boolean bl) {
        this.datasetDeletedAfterRequestedSyncCount = bl;
    }

    public ListRecordsResult withDatasetDeletedAfterRequestedSyncCount(Boolean bl) {
        this.datasetDeletedAfterRequestedSyncCount = bl;
        return this;
    }

    public Boolean getDatasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public String getSyncSessionToken() {
        return this.syncSessionToken;
    }

    public void setSyncSessionToken(String string) {
        this.syncSessionToken = string;
    }

    public ListRecordsResult withSyncSessionToken(String string) {
        this.syncSessionToken = string;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getRecords() != null) {
            stringBuilder.append("Records: " + this.getRecords() + ",");
        }
        if (this.getNextToken() != null) {
            stringBuilder.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getCount() != null) {
            stringBuilder.append("Count: " + this.getCount() + ",");
        }
        if (this.getDatasetSyncCount() != null) {
            stringBuilder.append("DatasetSyncCount: " + this.getDatasetSyncCount() + ",");
        }
        if (this.getLastModifiedBy() != null) {
            stringBuilder.append("LastModifiedBy: " + this.getLastModifiedBy() + ",");
        }
        if (this.getMergedDatasetNames() != null) {
            stringBuilder.append("MergedDatasetNames: " + this.getMergedDatasetNames() + ",");
        }
        if (this.isDatasetExists() != null) {
            stringBuilder.append("DatasetExists: " + this.isDatasetExists() + ",");
        }
        if (this.isDatasetDeletedAfterRequestedSyncCount() != null) {
            stringBuilder.append("DatasetDeletedAfterRequestedSyncCount: " + this.isDatasetDeletedAfterRequestedSyncCount() + ",");
        }
        if (this.getSyncSessionToken() != null) {
            stringBuilder.append("SyncSessionToken: " + this.getSyncSessionToken());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getRecords() == null ? 0 : ((Object)this.getRecords()).hashCode());
        n = 31 * n + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        n = 31 * n + (this.getCount() == null ? 0 : this.getCount().hashCode());
        n = 31 * n + (this.getDatasetSyncCount() == null ? 0 : this.getDatasetSyncCount().hashCode());
        n = 31 * n + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        n = 31 * n + (this.getMergedDatasetNames() == null ? 0 : ((Object)this.getMergedDatasetNames()).hashCode());
        n = 31 * n + (this.isDatasetExists() == null ? 0 : this.isDatasetExists().hashCode());
        n = 31 * n + (this.isDatasetDeletedAfterRequestedSyncCount() == null ? 0 : this.isDatasetDeletedAfterRequestedSyncCount().hashCode());
        n = 31 * n + (this.getSyncSessionToken() == null ? 0 : this.getSyncSessionToken().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListRecordsResult)) {
            return false;
        }
        ListRecordsResult listRecordsResult = (ListRecordsResult)object;
        if (listRecordsResult.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (listRecordsResult.getRecords() != null && !((Object)listRecordsResult.getRecords()).equals(this.getRecords())) {
            return false;
        }
        if (listRecordsResult.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (listRecordsResult.getNextToken() != null && !listRecordsResult.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (listRecordsResult.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (listRecordsResult.getCount() != null && !listRecordsResult.getCount().equals(this.getCount())) {
            return false;
        }
        if (listRecordsResult.getDatasetSyncCount() == null ^ this.getDatasetSyncCount() == null) {
            return false;
        }
        if (listRecordsResult.getDatasetSyncCount() != null && !listRecordsResult.getDatasetSyncCount().equals(this.getDatasetSyncCount())) {
            return false;
        }
        if (listRecordsResult.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (listRecordsResult.getLastModifiedBy() != null && !listRecordsResult.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (listRecordsResult.getMergedDatasetNames() == null ^ this.getMergedDatasetNames() == null) {
            return false;
        }
        if (listRecordsResult.getMergedDatasetNames() != null && !((Object)listRecordsResult.getMergedDatasetNames()).equals(this.getMergedDatasetNames())) {
            return false;
        }
        if (listRecordsResult.isDatasetExists() == null ^ this.isDatasetExists() == null) {
            return false;
        }
        if (listRecordsResult.isDatasetExists() != null && !listRecordsResult.isDatasetExists().equals(this.isDatasetExists())) {
            return false;
        }
        if (listRecordsResult.isDatasetDeletedAfterRequestedSyncCount() == null ^ this.isDatasetDeletedAfterRequestedSyncCount() == null) {
            return false;
        }
        if (listRecordsResult.isDatasetDeletedAfterRequestedSyncCount() != null && !listRecordsResult.isDatasetDeletedAfterRequestedSyncCount().equals(this.isDatasetDeletedAfterRequestedSyncCount())) {
            return false;
        }
        if (listRecordsResult.getSyncSessionToken() == null ^ this.getSyncSessionToken() == null) {
            return false;
        }
        return listRecordsResult.getSyncSessionToken() == null || listRecordsResult.getSyncSessionToken().equals(this.getSyncSessionToken());
    }
}

