/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.Dataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDatasetsResult
implements Serializable {
    private ListWithAutoConstructFlag<Dataset> datasets;
    private Integer count;
    private String nextToken;

    public List<Dataset> getDatasets() {
        if (this.datasets == null) {
            this.datasets = new ListWithAutoConstructFlag();
            this.datasets.setAutoConstruct(true);
        }
        return this.datasets;
    }

    public void setDatasets(Collection<Dataset> collection) {
        if (collection == null) {
            this.datasets = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.datasets = listWithAutoConstructFlag;
    }

    public ListDatasetsResult withDatasets(Dataset ... datasetArray) {
        if (this.getDatasets() == null) {
            this.setDatasets(new ArrayList<Dataset>(datasetArray.length));
        }
        for (Dataset dataset : datasetArray) {
            this.getDatasets().add(dataset);
        }
        return this;
    }

    public ListDatasetsResult withDatasets(Collection<Dataset> collection) {
        if (collection == null) {
            this.datasets = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.datasets = listWithAutoConstructFlag;
        }
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer n) {
        this.count = n;
    }

    public ListDatasetsResult withCount(Integer n) {
        this.count = n;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String string) {
        this.nextToken = string;
    }

    public ListDatasetsResult withNextToken(String string) {
        this.nextToken = string;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getDatasets() != null) {
            stringBuilder.append("Datasets: " + this.getDatasets() + ",");
        }
        if (this.getCount() != null) {
            stringBuilder.append("Count: " + this.getCount() + ",");
        }
        if (this.getNextToken() != null) {
            stringBuilder.append("NextToken: " + this.getNextToken());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getDatasets() == null ? 0 : ((Object)this.getDatasets()).hashCode());
        n = 31 * n + (this.getCount() == null ? 0 : this.getCount().hashCode());
        n = 31 * n + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListDatasetsResult)) {
            return false;
        }
        ListDatasetsResult listDatasetsResult = (ListDatasetsResult)object;
        if (listDatasetsResult.getDatasets() == null ^ this.getDatasets() == null) {
            return false;
        }
        if (listDatasetsResult.getDatasets() != null && !((Object)listDatasetsResult.getDatasets()).equals(this.getDatasets())) {
            return false;
        }
        if (listDatasetsResult.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (listDatasetsResult.getCount() != null && !listDatasetsResult.getCount().equals(this.getCount())) {
            return false;
        }
        if (listDatasetsResult.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return listDatasetsResult.getNextToken() == null || listDatasetsResult.getNextToken().equals(this.getNextToken());
    }
}

