/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.cognitosync.AmazonCognitoSync;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;

public class AmazonCognitoSyncClient
extends AmazonWebServiceClient
implements AmazonCognitoSync {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCognitoSync.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonCognitoSyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCognitoSyncClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonCognitoSyncClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(aWSCredentials);
        this.init();
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonCognitoSyncClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = aWSCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ResourceConflictExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NotAuthorizedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TooManyRequestsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("cognito-sync.us-east-1.amazonaws.com");
        HandlerChainFactory handlerChainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandlerChain("/com/amazonaws/services/cognitosync/request.handlers"));
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandler2Chain("/com/amazonaws/services/cognitosync/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration clientConfiguration) {
        ClientConfiguration clientConfiguration2 = clientConfiguration;
        return clientConfiguration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecordsResult updateRecords(UpdateRecordsRequest updateRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRecordsRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRecordsRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRecordsRequestMarshaller().marshall(updateRecordsRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateRecordsResultJsonUnmarshaller updateRecordsResultJsonUnmarshaller = new UpdateRecordsResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)updateRecordsResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            UpdateRecordsResult updateRecordsResult = (UpdateRecordsResult)response.getAwsResponse();
            return updateRecordsResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolUsageResult describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityPoolUsageRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityPoolUsageRequestMarshaller().marshall(describeIdentityPoolUsageRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeIdentityPoolUsageResultJsonUnmarshaller describeIdentityPoolUsageResultJsonUnmarshaller = new DescribeIdentityPoolUsageResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)describeIdentityPoolUsageResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DescribeIdentityPoolUsageResult describeIdentityPoolUsageResult = (DescribeIdentityPoolUsageResult)response.getAwsResponse();
            return describeIdentityPoolUsageResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestMarshaller().marshall(listDatasetsRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListDatasetsResultJsonUnmarshaller listDatasetsResultJsonUnmarshaller = new ListDatasetsResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)listDatasetsResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolUsageResult listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentityPoolUsageRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentityPoolUsageRequestMarshaller().marshall(listIdentityPoolUsageRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListIdentityPoolUsageResultJsonUnmarshaller listIdentityPoolUsageResultJsonUnmarshaller = new ListIdentityPoolUsageResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)listIdentityPoolUsageResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            ListIdentityPoolUsageResult listIdentityPoolUsageResult = (ListIdentityPoolUsageResult)response.getAwsResponse();
            return listIdentityPoolUsageResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResult listRecords(ListRecordsRequest listRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecordsRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecordsRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecordsRequestMarshaller().marshall(listRecordsRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListRecordsResultJsonUnmarshaller listRecordsResultJsonUnmarshaller = new ListRecordsResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)listRecordsResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            ListRecordsResult listRecordsResult = (ListRecordsResult)response.getAwsResponse();
            return listRecordsResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestMarshaller().marshall(describeDatasetRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeDatasetResultJsonUnmarshaller describeDatasetResultJsonUnmarshaller = new DescribeDatasetResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)describeDatasetResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DescribeDatasetResult describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            return describeDatasetResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestMarshaller().marshall(deleteDatasetRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteDatasetResultJsonUnmarshaller deleteDatasetResultJsonUnmarshaller = new DeleteDatasetResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)deleteDatasetResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityUsageResult describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityUsageRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityUsageRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityUsageRequestMarshaller().marshall(describeIdentityUsageRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeIdentityUsageResultJsonUnmarshaller describeIdentityUsageResultJsonUnmarshaller = new DescribeIdentityUsageResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)describeIdentityUsageResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DescribeIdentityUsageResult describeIdentityUsageResult = (DescribeIdentityUsageResult)response.getAwsResponse();
            return describeIdentityUsageResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    @Override
    public void setEndpoint(String string) {
        super.setEndpoint(string);
    }

    public void setEndpoint(String string, String string2, String string3) throws IllegalArgumentException {
        super.setEndpoint(string, string2, string3);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest amazonWebServiceRequest) {
        return this.client.getResponseMetadataForRequest(amazonWebServiceRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> httpResponseHandler, ExecutionContext executionContext) {
        AWSCredentials aWSCredentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            aWSCredentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        if (amazonWebServiceRequest != null && amazonWebServiceRequest.getRequestCredentials() != null) {
            aWSCredentials = amazonWebServiceRequest.getRequestCredentials();
        }
        executionContext.setCredentials(aWSCredentials);
        JsonErrorResponseHandler jsonErrorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response response = this.client.execute(request, httpResponseHandler, (HttpResponseHandler)jsonErrorResponseHandler, executionContext);
        return response;
    }
}

