/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.Intent;
import android.os.Bundle;
import com.amazonaws.services.cognitosync.model.InvalidParameterException;

public class PushSyncUpdate {
    private final String source;
    private final String identityPoolId;
    private final String identityId;
    private final String datasetName;
    private final long syncCount;

    PushSyncUpdate(Intent intent) {
        if (!PushSyncUpdate.isPushSyncUpdate(intent)) {
            throw new InvalidParameterException("Invalid bundle, only messages from Cognito for push sync are valid");
        }
        Bundle bundle = intent.getExtras();
        this.source = bundle.getString("source");
        this.identityPoolId = bundle.getString("identityPoolId");
        this.identityId = bundle.getString("identityId");
        this.datasetName = bundle.getString("datasetName");
        this.syncCount = Long.parseLong(bundle.getString("syncCount"));
    }

    public String getSource() {
        return this.source;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public long getSyncCount() {
        return this.syncCount;
    }

    public static boolean isPushSyncUpdate(Intent intent) {
        return intent.hasExtra("source") && intent.hasExtra("identityPoolId") && intent.hasExtra("identityId") && intent.hasExtra("datasetName") && intent.hasExtra("syncCount");
    }
}

