/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.SyncConflict;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataConflictException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DatasetNotFoundException;
import com.amazonaws.mobileconnectors.cognito.exceptions.NetworkException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.LocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.storage.RemoteDataStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.DatasetUtils;
import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DefaultDataset
implements Dataset {
    private static final String TAG = "DefaultDataset";
    private static final int MAX_RETRY = 3;
    private final Context context;
    private final String datasetName;
    private final LocalStorage local;
    private final RemoteDataStorage remote;
    private final CognitoCachingCredentialsProvider provider;
    private SyncOnConnectivity pendingSyncRequest = null;

    public DefaultDataset(Context context, String string, CognitoCachingCredentialsProvider cognitoCachingCredentialsProvider, LocalStorage localStorage, RemoteDataStorage remoteDataStorage) {
        this.context = context;
        this.datasetName = string;
        this.provider = cognitoCachingCredentialsProvider;
        this.local = localStorage;
        this.remote = remoteDataStorage;
    }

    @Override
    public void put(String string, String string2) {
        this.local.putValue(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(string), string2);
    }

    @Override
    public void remove(String string) {
        this.local.putValue(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(string), null);
    }

    @Override
    public String get(String string) {
        return this.local.getValue(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(string));
    }

    @Override
    public void synchronize(final Dataset.SyncCallback syncCallback) {
        if (syncCallback == null) {
            throw new IllegalArgumentException("callback can't ben null");
        }
        if (!DefaultDataset.isNetworkAvailable(this.context)) {
            syncCallback.onFailure(new NetworkException("Network connectivity unavailable."));
            return;
        }
        this.discardPendingSyncRequest();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.d((String)DefaultDataset.TAG, (String)("start to synchronize " + DefaultDataset.this.datasetName));
                boolean bl = false;
                try {
                    List<String> list = DefaultDataset.this.getLocalMergedDatasets();
                    boolean bl2 = true;
                    if (!list.isEmpty()) {
                        Log.i((String)DefaultDataset.TAG, (String)("detected merge datasets " + DefaultDataset.this.datasetName));
                        bl2 = syncCallback.onDatasetsMerged(DefaultDataset.this, list);
                    }
                    if (bl2) {
                        bl = DefaultDataset.this.synchronizeInternal(syncCallback, 3);
                    }
                }
                catch (Exception exception) {
                    syncCallback.onFailure(new DataStorageException("Unknown exception", exception));
                }
                if (bl) {
                    Log.d((String)DefaultDataset.TAG, (String)("successfully synchronize " + DefaultDataset.this.datasetName));
                } else {
                    Log.d((String)DefaultDataset.TAG, (String)("failed to synchronize " + DefaultDataset.this.datasetName));
                }
            }
        }).start();
    }

    synchronized boolean synchronizeInternal(Dataset.SyncCallback syncCallback, int n) {
        Object object;
        Record record;
        Object object2;
        List<Record> list;
        if (n < 0) {
            Log.e((String)TAG, (String)"synchronize failed because it exceeds maximum retry");
            return false;
        }
        long l = this.local.getLastSyncCount(this.getIdentityId(), this.datasetName);
        if (l == -1L) {
            try {
                try {
                    this.remote.deleteDataset(this.datasetName);
                }
                catch (DatasetNotFoundException datasetNotFoundException) {
                    // empty catch block
                }
                this.local.purgeDataset(this.getIdentityId(), this.datasetName);
                syncCallback.onSuccess(this, Collections.emptyList());
                return true;
            }
            catch (DataStorageException dataStorageException) {
                syncCallback.onFailure(dataStorageException);
                return false;
            }
        }
        Log.d((String)TAG, (String)("get latest modified records since " + l));
        RemoteDataStorage.DatasetUpdates datasetUpdates = null;
        try {
            datasetUpdates = this.remote.listUpdates(this.datasetName, l);
        }
        catch (DataStorageException dataStorageException) {
            syncCallback.onFailure(dataStorageException);
            return false;
        }
        if (!datasetUpdates.getMergedDatasetNameList().isEmpty()) {
            boolean bl = syncCallback.onDatasetsMerged(this, new ArrayList<String>(datasetUpdates.getMergedDatasetNameList()));
            if (bl) {
                return this.synchronizeInternal(syncCallback, --n);
            }
            syncCallback.onFailure(new DataStorageException("Manual cancel"));
            return false;
        }
        if (l != 0L && !datasetUpdates.isExists() || datasetUpdates.isDeleted()) {
            boolean bl = syncCallback.onDatasetDeleted(this, datasetUpdates.getDatasetName());
            if (bl) {
                this.local.deleteDataset(this.getIdentityId(), this.datasetName);
                this.local.purgeDataset(this.getIdentityId(), this.datasetName);
                syncCallback.onSuccess(this, Collections.emptyList());
                return true;
            }
            syncCallback.onFailure(new DataStorageException("Manual cancel"));
            return false;
        }
        List<Record> list2 = datasetUpdates.getRecords();
        l = datasetUpdates.getSyncCount();
        if (!list2.isEmpty()) {
            list = new ArrayList<Record>();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                record = object2.next();
                object = this.local.getRecord(this.getIdentityId(), this.datasetName, record.getKey());
                if (object == null || !((Record)object).isModified() || ((Record)object).getSyncCount() == record.getSyncCount() || StringUtils.equals(((Record)object).getValue(), record.getValue())) continue;
                list.add((Record)((Object)new SyncConflict(record, (Record)object)));
                object2.remove();
            }
            if (!list.isEmpty()) {
                Log.i((String)TAG, (String)String.format("%d records in conflict!", list.size()));
                if (!syncCallback.onConflict(this, list)) {
                    return false;
                }
            }
            if (!list2.isEmpty()) {
                Log.i((String)TAG, (String)String.format("save %d records to local", list2.size()));
                this.local.putRecords(this.getIdentityId(), this.datasetName, list2);
            }
            Log.i((String)TAG, (String)String.format("updated sync count %d", datasetUpdates.getSyncCount()));
            this.local.updateLastSyncCount(this.getIdentityId(), this.datasetName, datasetUpdates.getSyncCount());
        }
        if (!(list = this.getModifiedRecords()).isEmpty()) {
            Log.i((String)TAG, (String)String.format("push %d records to remote", list.size()));
            object2 = null;
            try {
                record = this.getSharedPreferences();
                object = record.getString("deviceId", null);
                object2 = this.remote.putRecords(this.datasetName, list, datasetUpdates.getSyncSessionToken(), (String)object);
            }
            catch (DataConflictException dataConflictException) {
                Log.i((String)TAG, (String)"conflicts detected when pushing changes to remote.");
                return this.synchronizeInternal(syncCallback, --n);
            }
            catch (DataStorageException dataStorageException) {
                syncCallback.onFailure(dataStorageException);
                return false;
            }
            this.local.putRecords(this.getIdentityId(), this.datasetName, (List<Record>)object2);
            long l2 = 0L;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Record record2 = (Record)iterator.next();
                l2 = l2 < record2.getSyncCount() ? record2.getSyncCount() : l2;
            }
            if (l2 == l + 1L) {
                Log.i((String)TAG, (String)String.format("updated sync count %d", l2));
                this.local.updateLastSyncCount(this.getIdentityId(), this.datasetName, l2);
            }
        }
        syncCallback.onSuccess(this, list2);
        return true;
    }

    @Override
    public List<Record> getAllRecords() {
        return this.local.getRecords(this.getIdentityId(), this.datasetName);
    }

    @Override
    public long getTotalSizeInBytes() {
        long l = 0L;
        for (Record record : this.local.getRecords(this.getIdentityId(), this.datasetName)) {
            l += DatasetUtils.computeRecordSize(record);
        }
        return l;
    }

    @Override
    public long getSizeInBytes(String string) {
        return DatasetUtils.computeRecordSize(this.local.getRecord(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(string)));
    }

    @Override
    public boolean isChanged(String string) {
        Record record = this.local.getRecord(this.getIdentityId(), this.datasetName, DatasetUtils.validateRecordKey(string));
        return record != null && record.isModified();
    }

    @Override
    public void delete() {
        this.local.deleteDataset(this.getIdentityId(), this.datasetName);
    }

    @Override
    public DatasetMetadata getDatasetMetadata() {
        return this.local.getDatasetMetadata(this.getIdentityId(), this.datasetName);
    }

    @Override
    public void resolve(List<Record> list) {
        this.local.putRecords(this.getIdentityId(), this.datasetName, list);
    }

    @Override
    public void putAll(Map<String, String> map) {
        for (String string : map.keySet()) {
            DatasetUtils.validateRecordKey(string);
        }
        this.local.putAllValues(this.getIdentityId(), this.datasetName, map);
    }

    @Override
    public Map<String, String> getAll() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Record record : this.local.getRecords(this.getIdentityId(), this.datasetName)) {
            if (record.isDeleted()) continue;
            hashMap.put(record.getKey(), record.getValue());
        }
        return hashMap;
    }

    String getIdentityId() {
        return DatasetUtils.getIdentityId(this.provider);
    }

    List<Record> getModifiedRecords() {
        return this.local.getModifiedRecords(this.getIdentityId(), this.datasetName);
    }

    List<String> getLocalMergedDatasets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.datasetName + ".";
        for (DatasetMetadata datasetMetadata : this.local.getDatasets(this.getIdentityId())) {
            if (!datasetMetadata.getDatasetName().startsWith(string)) continue;
            arrayList.add(datasetMetadata.getDatasetName());
        }
        return arrayList;
    }

    @Override
    public void synchronizeOnConnectivity(Dataset.SyncCallback syncCallback) {
        if (DefaultDataset.isNetworkAvailable(this.context)) {
            this.synchronize(syncCallback);
        } else {
            this.discardPendingSyncRequest();
            Log.d((String)TAG, (String)"Connectivity is unavailable. Scheduling synchronize for when connectivity is resumed.");
            this.pendingSyncRequest = new SyncOnConnectivity(this, syncCallback);
            this.context.registerReceiver((BroadcastReceiver)this.pendingSyncRequest, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discardPendingSyncRequest() {
        if (this.pendingSyncRequest != null) {
            Log.d((String)TAG, (String)"Discard previous pending sync request");
            DefaultDataset defaultDataset = this;
            synchronized (defaultDataset) {
                try {
                    this.context.unregisterReceiver((BroadcastReceiver)this.pendingSyncRequest);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.d((String)TAG, (String)"SyncOnConnectivity has been unregistered.");
                }
                this.pendingSyncRequest = null;
            }
        }
    }

    static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @Override
    public long getLastSyncCount() {
        return this.local.getLastSyncCount(this.getIdentityId(), this.datasetName);
    }

    @Override
    public void unsubscribe() {
        String string = this.getSharedPreferences().getString("deviceId", "");
        if (string.isEmpty()) {
            throw new IllegalStateException("Device hasn't been registered yet");
        }
        this.remote.unsubscribeFromDataset(this.datasetName, string);
    }

    @Override
    public void subscribe() {
        String string = this.getSharedPreferences().getString("deviceId", "");
        if (string.isEmpty()) {
            throw new IllegalStateException("Device hasn't been registered yet");
        }
        this.remote.subscribeToDataset(this.datasetName, string);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences("com.amazonaws.mobileconnectors.cognito", 0);
    }

    static class SyncOnConnectivity
    extends BroadcastReceiver {
        WeakReference<Dataset> datasetRef;
        WeakReference<Dataset.SyncCallback> callbackRef;

        SyncOnConnectivity(Dataset dataset, Dataset.SyncCallback syncCallback) {
            this.datasetRef = new WeakReference<Dataset>(dataset);
            this.callbackRef = new WeakReference<Dataset.SyncCallback>(syncCallback);
        }

        public void onReceive(Context context, Intent intent) {
            if (!DefaultDataset.isNetworkAvailable(context)) {
                Log.d((String)DefaultDataset.TAG, (String)"Connectivity is unavailable.");
                return;
            }
            Log.d((String)DefaultDataset.TAG, (String)"Connectivity is available. Try synchronizing.");
            context.unregisterReceiver((BroadcastReceiver)this);
            Dataset dataset = (Dataset)this.datasetRef.get();
            Dataset.SyncCallback syncCallback = (Dataset.SyncCallback)this.callbackRef.get();
            if (dataset == null || syncCallback == null) {
                Log.w((String)DefaultDataset.TAG, (String)"Abort syncOnConnectivity because either dataset or callback was garbage collected");
            } else {
                dataset.synchronize(syncCallback);
            }
        }
    }
}

