
/**
 * Synchronous and asynchronous client classes for accessing AmazonCloudWatch.
 *
 * Amazon CloudWatch <p>
 * This is the <i>Amazon CloudWatch API Reference</i> . This guide
 * provides detailed information about Amazon CloudWatch actions, data
 * types, parameters, and errors. For detailed information about Amazon
 * CloudWatch features and their associated API calls, go to the
 * <a href="http://docs.amazonwebservices.com/AmazonCloudWatch/latest/DeveloperGuide"> Amazon CloudWatch Developer Guide </a>
 * .
 * </p>
 * <p>
 * Amazon CloudWatch is a web service that enables you to publish,
 * monitor, and manage various metrics, as well as configure alarm
 * actions based on data from metrics. For more information about this
 * product go to
 * <a href="http://aws.amazon.com/cloudwatch"> http://aws.amazon.com/cloudwatch </a>
 * .
 * </p>
 * <p>
 * Use the following links to get started using the <i>Amazon CloudWatch
 * API Reference</i> :
 * </p>
 * 
 * <ul>
 * <li>
 * <a href="http://docs.amazonwebservices.com/AmazonCloudWatch/latest/APIReference/API_Operations.html"> Actions </a>
 * : An alphabetical list of all Amazon CloudWatch actions.</li>
 * <li>
 * <a href="http://docs.amazonwebservices.com/AmazonCloudWatch/latest/APIReference/API_Types.html"> Data Types </a>
 * : An alphabetical list of all Amazon CloudWatch data types.</li>
 * <li>
 * <a href="http://docs.amazonwebservices.com/AmazonCloudWatch/latest/APIReference/CommonParameters.html"> Common Parameters </a>
 * : Parameters that all Query actions can use.</li>
 * <li>
 * <a href="http://docs.amazonwebservices.com/AmazonCloudWatch/latest/APIReference/CommonErrors.html"> Common Errors </a>
 * : Client and server errors that all actions can return.</li>
 * <li>
 * <a href="http://docs.amazonwebservices.com/general/latest/gr/index.html?rande.html"> Regions and Endpoints </a>
 * : Itemized regions and endpoints for all AWS products.</li>
 * <li>
 * <a href="http://monitoring.amazonaws.com/doc/2010-08-01/CloudWatch.wsdl"> WSDL Location </a>
 * : http://monitoring.amazonaws.com/doc/2010-08-01/CloudWatch.wsdl</li>
 * 
 * </ul>
 */
 package com.amazonaws.services.cloudwatch;
        