/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.message;

import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.util.Base64;
import jakarta.jms.JMSException;
import jakarta.jms.ObjectMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSObjectMessage
extends SQSMessage
implements ObjectMessage {
    private static final Log LOG = LogFactory.getLog(SQSObjectMessage.class);
    private String body;

    public SQSObjectMessage(Acknowledger acknowledger, String queueUrl, Message sqsMessage) throws JMSException {
        super(acknowledger, queueUrl, sqsMessage);
        this.body = sqsMessage.getBody();
    }

    public SQSObjectMessage() throws JMSException {
    }

    public SQSObjectMessage(Serializable payload) throws JMSException {
        this.body = SQSObjectMessage.serialize(payload);
    }

    public void setObject(Serializable payload) throws JMSException {
        this.checkBodyWritePermissions();
        this.body = SQSObjectMessage.serialize(payload);
    }

    public Serializable getObject() throws JMSException {
        return SQSObjectMessage.deserialize(this.body);
    }

    @Override
    public void clearBody() throws JMSException {
        this.body = null;
        this.setBodyWritePermissions(true);
    }

    protected static Serializable deserialize(String serialized) throws JMSException {
        Serializable deserializedObject;
        if (serialized == null) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        try {
            byte[] bytes = Base64.decode((String)serialized);
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            deserializedObject = (Serializable)objectInputStream.readObject();
        }
        catch (IOException e) {
            LOG.error((Object)"IOException: Message cannot be written", (Throwable)e);
            throw SQSObjectMessage.convertExceptionToMessageFormatException(e);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception: ", (Throwable)e);
            throw SQSObjectMessage.convertExceptionToMessageFormatException(e);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return deserializedObject;
    }

    protected static String serialize(Serializable serializable) throws JMSException {
        String serializedString;
        if (serializable == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(bytesOut);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            serializedString = Base64.encodeAsString((byte[])bytesOut.toByteArray());
        }
        catch (IOException e) {
            LOG.error((Object)"IOException: cannot serialize objectMessage", (Throwable)e);
            throw SQSObjectMessage.convertExceptionToMessageFormatException(e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return serializedString;
    }

    public String getMessageBody() {
        return this.body;
    }

    void setMessageBody(String body) {
        this.body = body;
    }
}

