/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSQueueDestination;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.message.SQSBytesMessage;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import com.amazon.sqs.javamessaging.message.SQSObjectMessage;
import com.amazon.sqs.javamessaging.message.SQSTextMessage;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.util.Base64;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSMessageProducer
implements MessageProducer,
QueueSender {
    private static final Log LOG = LogFactory.getLog(SQSMessageProducer.class);
    private final long MAXIMUM_DELIVERY_DELAY_MILLISECONDS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
    private int deliveryDelaySeconds = 0;
    private long timeToLive;
    private int defaultPriority;
    private int deliveryMode;
    private boolean disableMessageTimestamp;
    private boolean disableMessageID;
    final AtomicBoolean closed = new AtomicBoolean(false);
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final SQSQueueDestination sqsDestination;
    private final SQSSession parentSQSSession;

    SQSMessageProducer(AmazonSQSMessagingClientWrapper amazonSQSClient, SQSSession parentSQSSession, SQSQueueDestination destination) throws JMSException {
        this.sqsDestination = destination;
        this.amazonSQSClient = amazonSQSClient;
        this.parentSQSSession = parentSQSSession;
    }

    void sendInternal(SQSQueueDestination queue, Message rawMessage) throws JMSException {
        this.checkClosed();
        String sqsMessageBody = null;
        String messageType = null;
        if (!(rawMessage instanceof SQSMessage)) {
            throw new MessageFormatException("Unrecognized message type. Messages have to be one of: SQSBytesMessage, SQSObjectMessage, or SQSTextMessage");
        }
        SQSMessage message = (SQSMessage)rawMessage;
        message.setJMSDestination(queue);
        if (message instanceof SQSBytesMessage) {
            sqsMessageBody = Base64.encodeAsString((byte[])((SQSBytesMessage)message).getBodyAsBytes());
            messageType = "byte";
        } else if (message instanceof SQSObjectMessage) {
            sqsMessageBody = ((SQSObjectMessage)message).getMessageBody();
            messageType = "object";
        } else if (message instanceof SQSTextMessage) {
            sqsMessageBody = ((SQSTextMessage)message).getText();
            messageType = "text";
        }
        if (sqsMessageBody == null || sqsMessageBody.isEmpty()) {
            throw new JMSException("Message body cannot be null or empty");
        }
        Map<String, MessageAttributeValue> messageAttributes = this.propertyToMessageAttribute(message);
        this.addStringAttribute(messageAttributes, "JMS_SQSMessageType", messageType);
        this.addReplyToQueueReservedAttributes(messageAttributes, message);
        this.addCorrelationIDToQueueReservedAttributes(messageAttributes, message);
        SendMessageRequest sendMessageRequest = new SendMessageRequest(queue.getQueueUrl(), sqsMessageBody);
        sendMessageRequest.setMessageAttributes(messageAttributes);
        if (this.deliveryDelaySeconds != 0) {
            sendMessageRequest.setDelaySeconds(Integer.valueOf(this.deliveryDelaySeconds));
        }
        if (queue.isFifo()) {
            sendMessageRequest.setMessageGroupId(message.getSQSMessageGroupId());
            sendMessageRequest.setMessageDeduplicationId(message.getSQSMessageDeduplicationId());
        }
        SendMessageResult sendMessageResult = this.amazonSQSClient.sendMessage(sendMessageRequest);
        String messageId = sendMessageResult.getMessageId();
        LOG.info((Object)("Message sent to SQS with SQS-assigned messageId: " + messageId));
        message.setSQSMessageId(messageId);
        if (sendMessageResult.getSequenceNumber() != null) {
            message.setSequenceNumber(sendMessageResult.getSequenceNumber());
        }
    }

    public Queue getQueue() throws JMSException {
        return this.sqsDestination;
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (!(queue instanceof SQSQueueDestination)) {
            throw new InvalidDestinationException("Incompatible implementation of Queue. Please use SQSQueueDestination implementation.");
        }
        this.checkIfDestinationAlreadySet();
        this.sendInternal((SQSQueueDestination)queue, message);
    }

    Map<String, MessageAttributeValue> propertyToMessageAttribute(SQSMessage message) throws JMSException {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        Enumeration<String> propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement();
            if (propertyName.equals("JMSXDeliveryCount") || propertyName.equals("JMS_SQS_DeduplicationId")) continue;
            SQSMessage.JMSMessagePropertyValue propertyObject = message.getJMSMessagePropertyValue(propertyName);
            MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
            messageAttributeValue.setDataType(propertyObject.getType());
            messageAttributeValue.setStringValue(propertyObject.getStringMessageAttributeValue());
            messageAttributes.put(propertyName, messageAttributeValue);
        }
        return messageAttributes;
    }

    private void addMessageTypeReservedAttribute(Map<String, MessageAttributeValue> messageAttributes, SQSMessage message, String value) throws JMSException {
        this.addStringAttribute(messageAttributes, "JMS_SQSMessageType", value);
    }

    private void addReplyToQueueReservedAttributes(Map<String, MessageAttributeValue> messageAttributes, SQSMessage message) throws JMSException {
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo instanceof SQSQueueDestination) {
            SQSQueueDestination replyToQueue = (SQSQueueDestination)replyTo;
            this.addStringAttribute(messageAttributes, "JMS_SQSReplyToQueueName", replyToQueue.getQueueName());
            this.addStringAttribute(messageAttributes, "JMS_SQSReplyToQueueURL", replyToQueue.getQueueUrl());
        }
    }

    private void addCorrelationIDToQueueReservedAttributes(Map<String, MessageAttributeValue> messageAttributes, SQSMessage message) throws JMSException {
        String correlationID = message.getJMSCorrelationID();
        if (correlationID != null) {
            this.addStringAttribute(messageAttributes, "JMS_SQSCorrelationID", correlationID);
        }
    }

    private void addStringAttribute(Map<String, MessageAttributeValue> messageAttributes, String key, String value) {
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        messageAttributeValue.setDataType("String");
        messageAttributeValue.setStringValue(value);
        messageAttributes.put(key, messageAttributeValue);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(queue, message);
    }

    public Destination getDestination() throws JMSException {
        return this.sqsDestination;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.parentSQSSession.removeProducer(this);
        }
    }

    public void send(Message message) throws JMSException {
        if (this.sqsDestination == null) {
            throw new UnsupportedOperationException("MessageProducer has to specify a destination at creation time.");
        }
        this.sendInternal(this.sqsDestination, message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message);
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Destination cannot be null");
        }
        if (!(destination instanceof SQSQueueDestination)) {
            throw new InvalidDestinationException("Incompatible implementation of Destination. Please use SQSQueueDestination implementation.");
        }
        this.send((Queue)destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(destination, message);
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.defaultPriority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    public void setDeliveryDelay(long deliveryDelay) {
        if (deliveryDelay < 0L || deliveryDelay > this.MAXIMUM_DELIVERY_DELAY_MILLISECONDS) {
            throw new IllegalArgumentException("Delivery delay must be non-negative and at most 15 minutes: " + deliveryDelay);
        }
        if (deliveryDelay % 1000L != 0L) {
            throw new IllegalArgumentException("Delivery delay must be a multiple of 1000: " + deliveryDelay);
        }
        this.deliveryDelaySeconds = (int)(deliveryDelay / 1000L);
    }

    public long getDeliveryDelay() {
        return (long)this.deliveryDelaySeconds * 1000L;
    }

    void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The producer is closed.");
        }
    }

    void checkIfDestinationAlreadySet() {
        if (this.sqsDestination != null) {
            throw new UnsupportedOperationException("MessageProducer already specified a destination at creation time.");
        }
    }

    AtomicBoolean isClosed() {
        return this.closed;
    }
}

