/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.payloadoffloading.PayloadStorageConfiguration;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;

@NotThreadSafe
public class ExtendedClientConfiguration
extends PayloadStorageConfiguration {
    private boolean cleanupS3Payload = true;
    private boolean useLegacyReservedAttributeName = true;
    private boolean ignorePayloadNotFound = false;

    public ExtendedClientConfiguration() {
        this.setPayloadSizeThreshold(262144);
    }

    public ExtendedClientConfiguration(ExtendedClientConfiguration other) {
        super((PayloadStorageConfiguration)other);
        this.cleanupS3Payload = other.doesCleanupS3Payload();
        this.useLegacyReservedAttributeName = other.usesLegacyReservedAttributeName();
        this.ignorePayloadNotFound = other.ignoresPayloadNotFound();
    }

    public void setPayloadSupportEnabled(S3Client s3, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        this.cleanupS3Payload = cleanupS3Payload;
    }

    public ExtendedClientConfiguration withPayloadSupportEnabled(S3Client s3, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3, s3BucketName, cleanupS3Payload);
        return this;
    }

    public void setLegacyReservedAttributeNameDisabled() {
        this.useLegacyReservedAttributeName = false;
    }

    public ExtendedClientConfiguration withLegacyReservedAttributeNameDisabled() {
        this.setLegacyReservedAttributeNameDisabled();
        return this;
    }

    public void setIgnorePayloadNotFound(boolean ignorePayloadNotFound) {
        this.ignorePayloadNotFound = ignorePayloadNotFound;
    }

    public ExtendedClientConfiguration withIgnorePayloadNotFound(boolean ignorePayloadNotFound) {
        this.setIgnorePayloadNotFound(ignorePayloadNotFound);
        return this;
    }

    public boolean doesCleanupS3Payload() {
        return this.cleanupS3Payload;
    }

    public boolean usesLegacyReservedAttributeName() {
        return this.useLegacyReservedAttributeName;
    }

    public boolean ignoresPayloadNotFound() {
        return this.ignorePayloadNotFound;
    }

    public ExtendedClientConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSupportEnabled(S3Client s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    public ExtendedClientConfiguration withObjectCannedACL(ObjectCannedACL objectCannedACL) {
        this.setObjectCannedACL(objectCannedACL);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public ExtendedClientConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public ExtendedClientConfiguration withServerSideEncryption(ServerSideEncryptionStrategy serverSideEncryption) {
        this.setServerSideEncryptionStrategy(serverSideEncryption);
        return this;
    }

    @Deprecated
    public void setLargePayloadSupportEnabled(S3Client s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
    }

    @Deprecated
    public ExtendedClientConfiguration withLargePayloadSupportEnabled(S3Client s3, String s3BucketName) {
        this.setLargePayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    @Deprecated
    public void setLargePayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
    }

    @Deprecated
    public ExtendedClientConfiguration withLargePayloadSupportDisabled() {
        this.setLargePayloadSupportDisabled();
        return this;
    }

    @Deprecated
    public boolean isLargePayloadSupportEnabled() {
        return this.isPayloadSupportEnabled();
    }

    @Deprecated
    public void setMessageSizeThreshold(int messageSizeThreshold) {
        this.setPayloadSizeThreshold(messageSizeThreshold);
    }

    @Deprecated
    public ExtendedClientConfiguration withMessageSizeThreshold(int messageSizeThreshold) {
        this.setMessageSizeThreshold(messageSizeThreshold);
        return this;
    }

    @Deprecated
    public int getMessageSizeThreshold() {
        return this.getPayloadSizeThreshold();
    }
}

