/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class RedshiftParameterMetaData
implements ParameterMetaData {
    private final BaseConnection connection;
    private final int[] oids;

    public RedshiftParameterMetaData(BaseConnection connection, int[] oids) {
        this.connection = connection;
        this.oids = oids;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().getJavaClass(this.oids[param - 1]);
    }

    @Override
    public int getParameterCount() {
        int rc = this.oids.length;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().getSQLType(this.oids[param - 1]);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().getRSType(this.oids[param - 1]);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().isSigned(this.oids[param - 1]);
    }

    private void checkParamIndex(int param) throws RedshiftException {
        if (param < 1 || param > this.oids.length) {
            throw new RedshiftException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", param, this.oids.length), RedshiftState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

