/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

public class RedshiftGeometry {
    private static final byte asciiInvalidValue = 127;

    public static byte[] transformEWKTFormat(byte[] bytes, int beginIndex, int length) {
        boolean errorFlag = false;
        int pointer = beginIndex;
        if (null == bytes) {
            return null;
        }
        if (0 == length) {
            return new byte[0];
        }
        if (1 == (beginIndex + length - pointer) % 2) {
            byte[] newArray = new byte[length];
            System.arraycopy(bytes, beginIndex, newArray, 0, length);
            return newArray;
        }
        byte[] result = new byte[(beginIndex + length - pointer) / 2];
        errorFlag = false;
        int i = 0;
        while (pointer < beginIndex + length) {
            int stage = RedshiftGeometry.hexEncodingLookupNoCase(bytes[pointer]) << 4;
            errorFlag = (byte)stage == 127 || errorFlag;
            int stage2 = RedshiftGeometry.hexEncodingLookupNoCase(bytes[++pointer]);
            errorFlag = (byte)stage2 == 127 || errorFlag;
            ++pointer;
            result[i] = (byte)(stage | stage2);
            ++i;
        }
        if (errorFlag) {
            byte[] newArray = new byte[length];
            System.arraycopy(bytes, beginIndex, newArray, 0, length);
            return newArray;
        }
        return result;
    }

    private static int hexEncodingLookupNoCase(byte inputValue) {
        int result = 127;
        switch (inputValue) {
            case 48: {
                result = 0;
                break;
            }
            case 49: {
                result = 1;
                break;
            }
            case 50: {
                result = 2;
                break;
            }
            case 51: {
                result = 3;
                break;
            }
            case 52: {
                result = 4;
                break;
            }
            case 53: {
                result = 5;
                break;
            }
            case 54: {
                result = 6;
                break;
            }
            case 55: {
                result = 7;
                break;
            }
            case 56: {
                result = 8;
                break;
            }
            case 57: {
                result = 9;
                break;
            }
            case 65: 
            case 97: {
                result = 10;
                break;
            }
            case 66: 
            case 98: {
                result = 11;
                break;
            }
            case 67: 
            case 99: {
                result = 12;
                break;
            }
            case 68: 
            case 100: {
                result = 13;
                break;
            }
            case 69: 
            case 101: {
                result = 14;
                break;
            }
            case 70: 
            case 102: {
                result = 15;
            }
        }
        return result;
    }

    public static String convertToString(byte[] data) {
        char[] hex = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            hexChars[i * 2] = hex[v >>> 4];
            hexChars[i * 2 + 1] = hex[v & 0xF];
        }
        return new String(hexChars);
    }
}

