/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.jdbc.RedshiftConnectionImpl;

public class Tuple {
    private final boolean forUpdate;
    final byte[][] data;
    private final int rowSize;

    public Tuple(int length) {
        this((byte[][])new byte[length][], true);
    }

    public Tuple(byte[][] data) {
        this(data, false);
    }

    public Tuple(byte[][] data, int rowSize) {
        this(data, false, rowSize);
    }

    private Tuple(byte[][] data, boolean forUpdate) {
        this(data, forUpdate, 0);
    }

    private Tuple(byte[][] data, boolean forUpdate, int rowSize) {
        this.data = data;
        this.forUpdate = forUpdate;
        this.rowSize = rowSize;
    }

    public int fieldCount() {
        return this.data.length;
    }

    public int length() {
        if (this.rowSize != 0) {
            return this.rowSize;
        }
        int length = 0;
        for (byte[] field : this.data) {
            if (field == null) continue;
            length += field.length;
        }
        return length;
    }

    public int getTupleSize() {
        int rawSize = 0;
        int nullFieldCount = 0;
        for (byte[] field : this.data) {
            if (field != null) {
                rawSize += field.length;
                continue;
            }
            ++nullFieldCount;
        }
        int refSize = RedshiftConnectionImpl.IS_64_BIT_JVM ? 8 : 4;
        int arrayHeaderSize = RedshiftConnectionImpl.IS_64_BIT_JVM ? 24 : 16;
        int overhead = (RedshiftConnectionImpl.IS_64_BIT_JVM ? 16 : 8) + refSize + refSize * this.data.length + arrayHeaderSize * (this.data.length - nullFieldCount) + arrayHeaderSize + 5;
        return rawSize + overhead;
    }

    public byte[] get(int index) {
        return this.data[index];
    }

    public Tuple updateableCopy() {
        return this.copy(true);
    }

    public Tuple readOnlyCopy() {
        return this.copy(false);
    }

    private Tuple copy(boolean forUpdate) {
        byte[][] dataCopy = new byte[this.data.length][];
        System.arraycopy(this.data, 0, dataCopy, 0, this.data.length);
        return new Tuple((byte[][])dataCopy, forUpdate);
    }

    public void set(int index, byte[] fieldData) {
        if (!this.forUpdate) {
            throw new IllegalArgumentException("Attempted to write to readonly tuple");
        }
        this.data[index] = fieldData;
    }
}

