/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.geometric.RedshiftLseg;
import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftLine
extends RedshiftObject
implements Serializable,
Cloneable {
    public double a;
    public double b;
    public double c;

    public RedshiftLine(double a, double b, double c) {
        this();
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public RedshiftLine(double x1, double y1, double x2, double y2) {
        this();
        if (x1 == x2) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (y2 - y1) / (x2 - x1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * x1;
    }

    public RedshiftLine(RedshiftPoint p1, RedshiftPoint p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public RedshiftLine(RedshiftLseg lseg) {
        this(lseg.point[0], lseg.point[1]);
    }

    public RedshiftLine(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public RedshiftLine() {
        this.setType("line");
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.trim().startsWith("{")) {
            RedshiftTokenizer t = new RedshiftTokenizer(RedshiftTokenizer.removeCurlyBrace(s), ',');
            if (t.getSize() != 3) {
                throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), RedshiftState.DATA_TYPE_MISMATCH);
            }
            this.a = Double.parseDouble(t.getToken(0));
            this.b = Double.parseDouble(t.getToken(1));
            this.c = Double.parseDouble(t.getToken(2));
        } else if (s.trim().startsWith("[")) {
            RedshiftTokenizer t = new RedshiftTokenizer(RedshiftTokenizer.removeBox(s), ',');
            if (t.getSize() != 2) {
                throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), RedshiftState.DATA_TYPE_MISMATCH);
            }
            RedshiftPoint point1 = new RedshiftPoint(t.getToken(0));
            RedshiftPoint point2 = new RedshiftPoint(t.getToken(1));
            this.a = point2.x - point1.x;
            this.b = point2.y - point1.y;
            this.c = point1.y;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RedshiftLine pGline = (RedshiftLine)obj;
        return Double.compare(pGline.a, this.a) == 0 && Double.compare(pGline.b, this.b) == 0 && Double.compare(pGline.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String getValue() {
        return "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

