/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.LogLevel;
import com.amazon.support.SettingReader;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PGLogger
extends DSILogger
implements IPGLogger {
    private PrintWriter m_externalLogWriter = null;
    private LogLevel m_externallevel = LogLevel.OFF;
    private int m_connectionId = -1;

    public PGLogger(String string, int n) {
        super(string + n);
        String string2 = SettingReader.readSetting("DriverLogLevel");
        this.m_externallevel = this.getExternalLogLevel(string2);
        this.m_externalLogWriter = DriverManager.getLogWriter();
        this.m_connectionId = n;
    }

    @Override
    public LogLevel getExternalLogLevel() {
        return this.m_externallevel;
    }

    @Override
    public boolean isExternalLoggerEnabled() {
        return this.m_externallevel != LogLevel.OFF;
    }

    @Override
    public void logDebugExternal(String string) {
        this.logMessage(LogLevel.DEBUG, string);
    }

    @Override
    public void logInfoExternal(String string) {
        this.logMessage(LogLevel.INFO, string);
    }

    @Override
    public void setExternalLogLevel(LogLevel logLevel) {
        this.m_externallevel = logLevel;
    }

    private String formatLogLine(LogLevel logLevel, String string) {
        if (null == this.m_externalLogWriter) {
            return null;
        }
        String string2 = null;
        if (this.isInExternalLevel(logLevel)) {
            StringBuffer stringBuffer = new StringBuffer();
            SimpleDateFormat simpleDateFormat = null;
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(0));
            stringBuffer.append(" (");
            stringBuffer.append(this.m_connectionId);
            stringBuffer.append(") ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private boolean isInExternalLevel(LogLevel logLevel) {
        return logLevel.ordinal() <= this.m_externallevel.ordinal();
    }

    private void logMessage(LogLevel logLevel, String string) {
        string = this.formatLogLine(logLevel, string);
        if (null != this.m_externalLogWriter && null != string) {
            this.m_externalLogWriter.print(string);
            this.m_externalLogWriter.flush();
        }
    }

    private LogLevel getExternalLogLevel(String string) {
        LogLevel logLevel = LogLevel.OFF;
        try {
            int n = Integer.parseInt(string);
            if (n == 1) {
                logLevel = LogLevel.INFO;
            } else if (n >= 2) {
                logLevel = LogLevel.DEBUG;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return logLevel;
    }
}

