/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.amazonaws.AmazonClientException;
import com.amazon.redshift.amazonaws.AmazonWebServiceRequest;
import com.amazon.redshift.amazonaws.AmazonWebServiceResult;
import com.amazon.redshift.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazon.redshift.amazonaws.auth.BasicAWSCredentials;
import com.amazon.redshift.amazonaws.auth.BasicSessionCredentials;
import com.amazon.redshift.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazon.redshift.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazon.redshift.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazon.redshift.amazonaws.client.builder.AwsClientBuilder;
import com.amazon.redshift.amazonaws.services.redshift.AmazonRedshift;
import com.amazon.redshift.amazonaws.services.redshift.AmazonRedshiftClientBuilder;
import com.amazon.redshift.amazonaws.services.redshift.model.Cluster;
import com.amazon.redshift.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazon.redshift.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazon.redshift.amazonaws.services.redshift.model.Endpoint;
import com.amazon.redshift.amazonaws.services.redshift.model.GetClusterCredentialsRequest;
import com.amazon.redshift.amazonaws.services.redshift.model.GetClusterCredentialsResult;
import com.amazon.redshift.amazonaws.util.StringUtils;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PluginProfilesConfigFile;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class IamHelper {
    private IamHelper() {
    }

    public static void setIAMProperties(ConnSettingRequestMap connSettingRequestMap, PGJDBCSettings pGJDBCSettings, ILogger iLogger) throws ErrorException {
        if (pGJDBCSettings.m_authMech.ordinal() < AuthMech.VERIFY_CA.ordinal()) {
            pGJDBCSettings.m_authMech = AuthMech.VERIFY_CA;
        }
        Variant variant = PGJDBCConnection.getRequiredConnSetting("ClusterID", connSettingRequestMap);
        Variant variant2 = PGJDBCConnection.getOptionalConnSetting("Region", connSettingRequestMap);
        Variant variant3 = PGJDBCConnection.getOptionalConnSetting("EndpointUrl", connSettingRequestMap);
        Variant variant4 = PGJDBCConnection.getOptionalConnSetting("UID", connSettingRequestMap);
        Variant variant5 = PGJDBCConnection.getOptionalConnSetting("PWD", connSettingRequestMap);
        Variant variant6 = PGJDBCConnection.getOptionalConnSetting("profile", connSettingRequestMap);
        Variant variant7 = PGJDBCConnection.getOptionalConnSetting("IAMDuration", connSettingRequestMap);
        Variant variant8 = PGJDBCConnection.getOptionalConnSetting("AccessKeyID", connSettingRequestMap);
        Variant variant9 = PGJDBCConnection.getOptionalConnSetting("SecretAccessKey", connSettingRequestMap);
        Variant variant10 = PGJDBCConnection.getOptionalConnSetting("SessionToken", connSettingRequestMap);
        Variant variant11 = PGJDBCConnection.getOptionalConnSetting("plugin_name", connSettingRequestMap);
        Variant variant12 = PGJDBCConnection.getOptionalConnSetting("AutoCreate", connSettingRequestMap);
        Variant variant13 = PGJDBCConnection.getOptionalConnSetting("DbUser", connSettingRequestMap);
        Variant variant14 = PGJDBCConnection.getOptionalConnSetting("DbGroups", connSettingRequestMap);
        pGJDBCSettings.m_clusterIdentifier = variant.getString();
        if (pGJDBCSettings.m_clusterIdentifier.isEmpty()) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, "ClusterID");
            LogUtilities.logError(errorException, iLogger);
            throw errorException;
        }
        if (null != variant2) {
            pGJDBCSettings.m_awsRegion = variant2.getString().trim().toLowerCase();
        }
        pGJDBCSettings.m_endpoint = null != variant3 ? variant3.getString() : System.getProperty("redshift.endpoint-url");
        if (null != variant4) {
            pGJDBCSettings.m_username = variant4.getString();
        }
        if (null != variant5) {
            pGJDBCSettings.m_password = variant5.getString();
        }
        if (null != variant6) {
            pGJDBCSettings.m_profile = variant6.getString();
        }
        if (null != variant7) {
            try {
                pGJDBCSettings.m_iamDuration = Integer.parseInt(variant7.getString());
                if (pGJDBCSettings.m_iamDuration < 900 || pGJDBCSettings.m_iamDuration > 3600) {
                    ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE_TYPE_OR_RANGE.name(), new String[]{"IAMDuration", variant7.getString(), "900", "3600"});
                    LogUtilities.logError(errorException, iLogger);
                    throw errorException;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{"IAMDuration", variant7.getString()});
                LogUtilities.logError(errorException, iLogger);
                throw errorException;
            }
        }
        if (null != variant8) {
            pGJDBCSettings.m_iamAccessKeyID = variant8.getString();
        }
        if (null != variant9) {
            if (StringUtils.isNullOrEmpty(pGJDBCSettings.m_iamAccessKeyID)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, "AccessKeyID");
                LogUtilities.logError(errorException, iLogger);
                throw errorException;
            }
            pGJDBCSettings.m_iamSecretKey = variant9.getString();
            if (pGJDBCSettings.m_iamSecretKey.isEmpty()) {
                pGJDBCSettings.m_iamSecretKey = pGJDBCSettings.m_password;
            }
        } else {
            pGJDBCSettings.m_iamSecretKey = pGJDBCSettings.m_password;
        }
        if (null != variant10) {
            if (StringUtils.isNullOrEmpty(pGJDBCSettings.m_iamAccessKeyID)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, "AccessKeyID");
                LogUtilities.logError(errorException, iLogger);
                throw errorException;
            }
            pGJDBCSettings.m_iamSessionToken = variant10.getString();
        }
        if (null != variant11) {
            pGJDBCSettings.m_credentialsProvider = variant11.getString();
        }
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toLowerCase(Locale.getDefault());
            String string2 = connSettingRequestMap.getProperty(string).getString();
            if ("*".equals(string2)) continue;
            pGJDBCSettings.m_pluginArgs.put(string, string2);
        }
        Boolean bl = pGJDBCSettings.m_autocreate = variant12 == null ? null : Boolean.valueOf(variant12.getString());
        if (null != variant13) {
            pGJDBCSettings.m_dbUser = variant13.getString();
        }
        pGJDBCSettings.m_dbGroups = variant14 != null ? Arrays.asList(variant14.getString().split(",")) : Collections.emptyList();
        IamHelper.setIAMCredentials(pGJDBCSettings, iLogger);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void setIAMCredentials(PGJDBCSettings var0, ILogger var1_1) throws ErrorException {
        if (!StringUtils.isNullOrEmpty(var0.m_credentialsProvider)) {
            if (!StringUtils.isNullOrEmpty(var0.m_profile)) {
                var2_2 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR, new String[]{"plugin_name", "profile"});
                LogUtilities.logError(var2_2, var1_1);
                throw var2_2;
            }
            if (!StringUtils.isNullOrEmpty(var0.m_iamAccessKeyID)) {
                var2_3 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR, new String[]{"plugin_name", "AccessKeyID"});
                LogUtilities.logError(var2_3, var1_1);
                throw var2_3;
            }
            try {
                var2_4 = Class.forName(var0.m_credentialsProvider).asSubclass(AWSCredentialsProvider.class);
                var3_9 /* !! */  = (AWSCredentialsProvider)var2_4.newInstance();
                if (!(var3_9 /* !! */  instanceof IPlugin)) ** GOTO lbl45
                var4_10 = (IPlugin)var3_9 /* !! */ ;
                var4_10.setILogger(var1_1);
                for (Object var6_15 : var0.m_pluginArgs.entrySet()) {
                    var4_10.addParameter((String)var6_15.getKey(), (String)var6_15.getValue());
                }
            }
            catch (InstantiationException var2_5) {
                var4_11 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_CREDENTIALS_PROVIDER_CLASS, var0.m_credentialsProvider);
                LogUtilities.logError(var4_11, var1_1);
                throw var4_11;
            }
            catch (IllegalAccessException var2_6) {
                var4_12 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_CREDENTIALS_PROVIDER_CLASS, var0.m_credentialsProvider);
                LogUtilities.logError(var4_12, var1_1);
                throw var4_12;
            }
            catch (ClassNotFoundException var2_7) {
                var4_13 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_CREDENTIALS_PROVIDER_CLASS, var0.m_credentialsProvider);
                LogUtilities.logError(var4_13, var1_1);
                throw var4_13;
            }
        } else if (!StringUtils.isNullOrEmpty(var0.m_profile)) {
            if (!StringUtils.isNullOrEmpty(var0.m_iamAccessKeyID)) {
                var2_8 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR, new String[]{"profile", "AccessKeyID"});
                LogUtilities.logError(var2_8, var1_1);
                throw var2_8;
            }
            var2_4 = new PluginProfilesConfigFile(var0, var1_1);
            var3_9 /* !! */  = new ProfileCredentialsProvider((ProfilesConfigFile)var2_4, var0.m_profile);
        } else if (!StringUtils.isNullOrEmpty(var0.m_iamAccessKeyID)) {
            var2_4 = StringUtils.isNullOrEmpty(var0.m_iamSessionToken) == false ? new BasicSessionCredentials(var0.m_iamAccessKeyID, var0.m_iamSecretKey, var0.m_iamSessionToken) : new BasicAWSCredentials(var0.m_iamAccessKeyID, var0.m_iamSecretKey);
            var3_9 /* !! */  = new AWSStaticCredentialsProvider((AWSCredentials)var2_4);
        } else {
            var3_9 /* !! */  = new DefaultAWSCredentialsProviderChain();
        }
lbl45:
        // 5 sources

        var2_4 = var3_9 /* !! */ .getCredentials();
        if (var2_4 instanceof CredentialsHolder && null != (var4_10 = ((CredentialsHolder)var2_4).getMetadata())) {
            var5_14 = var4_10.getAutoCreate();
            var6_15 = var4_10.getDbUser();
            var7_16 = var4_10.getSamlDbUser();
            var8_17 = var4_10.getProfileDbUser();
            var9_18 = var4_10.getDbGroups();
            var10_19 = var4_10.getAllowDbUserOverride();
            if (null == var0.m_autocreate) {
                var0.m_autocreate = var5_14;
            }
            if (var10_19) {
                if (null != var7_16) {
                    var0.m_dbUser = var7_16;
                } else if (null != var6_15) {
                    var0.m_dbUser = var6_15;
                } else if (null != var8_17) {
                    var0.m_dbUser = var8_17;
                }
            } else if (null != var6_15) {
                var0.m_dbUser = var6_15;
            } else if (null != var8_17) {
                var0.m_dbUser = var8_17;
            } else if (null != var7_16) {
                var0.m_dbUser = var7_16;
            }
            if (var0.m_dbGroups.isEmpty() && null != var9_18) {
                var0.m_dbGroups = Arrays.asList(var9_18.split(","));
            }
        }
        if ("*".equals(var0.m_username) && null == var0.m_dbUser) {
            var4_10 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR, "DbUser");
            LogUtilities.logError((ErrorException)var4_10, var1_1);
            throw var4_10;
        }
        IamHelper.setClusterCredentials(var3_9 /* !! */ , var0, var1_1);
    }

    private static void setClusterCredentials(AWSCredentialsProvider aWSCredentialsProvider, PGJDBCSettings pGJDBCSettings, ILogger iLogger) throws ErrorException {
        try {
            AmazonWebServiceResult amazonWebServiceResult;
            AmazonWebServiceRequest amazonWebServiceRequest;
            Object object;
            AmazonRedshiftClientBuilder amazonRedshiftClientBuilder = AmazonRedshiftClientBuilder.standard();
            if (pGJDBCSettings.m_endpoint != null) {
                object = new AwsClientBuilder.EndpointConfiguration(pGJDBCSettings.m_endpoint, pGJDBCSettings.m_endpoint);
                amazonRedshiftClientBuilder.setEndpointConfiguration((AwsClientBuilder.EndpointConfiguration)object);
            } else if (pGJDBCSettings.m_awsRegion != null && !pGJDBCSettings.m_awsRegion.isEmpty()) {
                amazonRedshiftClientBuilder.setRegion(pGJDBCSettings.m_awsRegion);
            }
            object = (AmazonRedshift)((AmazonRedshiftClientBuilder)amazonRedshiftClientBuilder.withCredentials(aWSCredentialsProvider)).build();
            if (null == pGJDBCSettings.m_host || pGJDBCSettings.m_port == 0) {
                amazonWebServiceRequest = new DescribeClustersRequest();
                ((DescribeClustersRequest)amazonWebServiceRequest).setClusterIdentifier(pGJDBCSettings.m_clusterIdentifier);
                amazonWebServiceResult = object.describeClusters((DescribeClustersRequest)amazonWebServiceRequest);
                List<Cluster> list = ((DescribeClustersResult)amazonWebServiceResult).getClusters();
                if (list.isEmpty()) {
                    throw new AmazonClientException("Failed to describeClusters.");
                }
                Cluster cluster = list.get(0);
                Endpoint endpoint = cluster.getEndpoint();
                if (null == endpoint) {
                    throw new AmazonClientException("Cluster is not fully created yet.");
                }
                pGJDBCSettings.m_host = endpoint.getAddress();
                pGJDBCSettings.m_port = endpoint.getPort();
            }
            amazonWebServiceRequest = new GetClusterCredentialsRequest();
            ((GetClusterCredentialsRequest)amazonWebServiceRequest).setClusterIdentifier(pGJDBCSettings.m_clusterIdentifier);
            if (pGJDBCSettings.m_iamDuration > 0) {
                ((GetClusterCredentialsRequest)amazonWebServiceRequest).setDurationSeconds(pGJDBCSettings.m_iamDuration);
            }
            ((GetClusterCredentialsRequest)amazonWebServiceRequest).setDbName(pGJDBCSettings.m_Schema);
            ((GetClusterCredentialsRequest)amazonWebServiceRequest).setDbUser(pGJDBCSettings.m_dbUser == null ? pGJDBCSettings.m_username : pGJDBCSettings.m_dbUser);
            ((GetClusterCredentialsRequest)amazonWebServiceRequest).setAutoCreate(pGJDBCSettings.m_autocreate);
            ((GetClusterCredentialsRequest)amazonWebServiceRequest).setDbGroups(pGJDBCSettings.m_dbGroups);
            LogUtilities.logTrace(((GetClusterCredentialsRequest)amazonWebServiceRequest).toString(), iLogger);
            amazonWebServiceResult = object.getClusterCredentials((GetClusterCredentialsRequest)amazonWebServiceRequest);
            pGJDBCSettings.m_username = ((GetClusterCredentialsResult)amazonWebServiceResult).getDbUser();
            pGJDBCSettings.m_password = ((GetClusterCredentialsResult)amazonWebServiceResult).getDbPassword();
        }
        catch (AmazonClientException amazonClientException) {
            LogUtilities.logError(amazonClientException, iLogger);
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_IAM_ERROR_RETRIEVING_TEMP_CREDS, amazonClientException.getMessage());
            LogUtilities.logError(errorException, iLogger);
            throw errorException;
        }
    }
}

