/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.internal.SdkInternalList;
import com.amazon.redshift.amazonaws.services.redshift.model.GetClusterCredentialsRequest;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class GetClusterCredentialsRequestMarshaller
implements Marshaller<Request<GetClusterCredentialsRequest>, GetClusterCredentialsRequest> {
    @Override
    public Request<GetClusterCredentialsRequest> marshall(GetClusterCredentialsRequest getClusterCredentialsRequest) {
        SdkInternalList dbGroupsList;
        if (getClusterCredentialsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetClusterCredentialsRequest> request = new DefaultRequest<GetClusterCredentialsRequest>(getClusterCredentialsRequest, "AmazonRedshift");
        request.addParameter("Action", "GetClusterCredentials");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getClusterCredentialsRequest.getDbUser() != null) {
            request.addParameter("DbUser", StringUtils.fromString(getClusterCredentialsRequest.getDbUser()));
        }
        if (getClusterCredentialsRequest.getDbName() != null) {
            request.addParameter("DbName", StringUtils.fromString(getClusterCredentialsRequest.getDbName()));
        }
        if (getClusterCredentialsRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(getClusterCredentialsRequest.getClusterIdentifier()));
        }
        if (getClusterCredentialsRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger(getClusterCredentialsRequest.getDurationSeconds()));
        }
        if (getClusterCredentialsRequest.getAutoCreate() != null) {
            request.addParameter("AutoCreate", StringUtils.fromBoolean(getClusterCredentialsRequest.getAutoCreate()));
        }
        if (!(dbGroupsList = (SdkInternalList)getClusterCredentialsRequest.getDbGroups()).isEmpty() || !dbGroupsList.isAutoConstruct()) {
            int dbGroupsListIndex = 1;
            for (String dbGroupsListValue : dbGroupsList) {
                if (dbGroupsListValue != null) {
                    request.addParameter("DbGroups.DbGroup." + dbGroupsListIndex, StringUtils.fromString(dbGroupsListValue));
                }
                ++dbGroupsListIndex;
            }
        }
        return request;
    }
}

