/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.IonBufferConfiguration;
import com.amazon.ion.IonException;
import com.amazon.ion.IonType;
import com.amazon.ion.impl.IonTypeID;
import com.amazon.ion.impl.ReaderLookaheadBufferBase;
import com.amazon.ion.impl.ResizingPipedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class IonReaderLookaheadBuffer
extends ReaderLookaheadBufferBase {
    private static final int LOWER_SEVEN_BITS_BITMASK = 127;
    private static final int HIGHEST_BIT_BITMASK = 128;
    private static final int VALUE_BITS_PER_VARUINT_BYTE = 7;
    private static final int MAXIMUM_SUPPORTED_VAR_UINT_BYTES = 9;
    private static final int IVM_START_BYTE = 224;
    private static final int IVM_REMAINING_LENGTH = 3;
    private static final int ION_SYMBOL_TABLE_SID = 3;
    private static final long MAXIMUM_VALUE_SIZE = Integer.MAX_VALUE;
    private final int pageSize;
    private final VarUInt inProgressVarUInt;
    private final List<Marker> symbolTableMarkers = new ArrayList<Marker>(2);
    private final Marker annotationSidsMarker = new Marker(-1, 0);
    private final IonBufferConfiguration.OversizedSymbolTableHandler oversizedSymbolTableHandler;
    private long additionalBytesNeeded;
    private boolean isSystemValue;
    private long numberOfAnnotationSidBytesRemaining;
    private long currentNumberOfAnnotations;
    private State state = State.BEFORE_TYPE_ID;
    private int valueStartWriteIndex;
    private int valueStartAvailable;
    private int valuePreHeaderIndex;
    private int valuePostHeaderIndex;
    private IonTypeID valueTid;
    private int valueEndIndex;
    private int nopPadStartIndex = -1;
    private int ivmSecondByteIndex = -1;
    private int peekIndex = 0;
    private boolean handlerNeedsToBeNotifiedOfOversizedValue = true;

    private void reset() {
        this.additionalBytesNeeded = 0L;
        this.isSystemValue = false;
        this.numberOfAnnotationSidBytesRemaining = 0L;
        this.currentNumberOfAnnotations = 0L;
        this.valuePreHeaderIndex = -1;
        this.valuePostHeaderIndex = -1;
        this.valueTid = null;
        this.valueEndIndex = -1;
        this.annotationSidsMarker.startIndex = -1;
        this.valueStartAvailable = this.pipe.available();
        this.startNewValue();
    }

    public IonReaderLookaheadBuffer(IonBufferConfiguration configuration, InputStream inputStream) {
        super(configuration, inputStream);
        this.pipe.registerNotificationConsumer(new ResizingPipedInputStream.NotificationConsumer(){

            @Override
            public void bytesConsolidatedToStartOfBuffer(int leftShiftAmount) {
                IonReaderLookaheadBuffer.this.shiftIndicesLeft(-1, leftShiftAmount);
            }
        });
        this.pageSize = configuration.getInitialBufferSize();
        this.oversizedSymbolTableHandler = configuration.getOversizedSymbolTableHandler();
        this.inProgressVarUInt = new VarUInt();
        this.reset();
    }

    private void initializeVarUInt(VarUInt.Location location) {
        this.inProgressVarUInt.reset(location);
        this.state = State.READING_HEADER;
    }

    private int readByte() throws Exception {
        int b;
        if (this.pipe.availableBeyondBoundary() == 0 && this.fillPage(1) < 1) {
            return -1;
        }
        if (this.isSkippingCurrentValue()) {
            b = this.getInput().read();
        } else {
            b = this.pipe.peek(this.peekIndex);
            this.pipe.extendBoundary(1);
            ++this.peekIndex;
        }
        return b;
    }

    private void readVarUInt() throws Exception {
        while (this.inProgressVarUInt.numberOfBytesRead < 9) {
            int currentByte = this.readByte();
            if (currentByte < 0) {
                return;
            }
            this.inProgressVarUInt.numberOfBytesRead++;
            this.inProgressVarUInt.value = this.inProgressVarUInt.value << 7 | (long)(currentByte & 0x7F);
            if ((currentByte & 0x80) == 0) continue;
            this.inProgressVarUInt.isComplete = true;
            this.dataHandler.onData(this.inProgressVarUInt.numberOfBytesRead);
            return;
        }
        throw new IonException("Found a VarUInt that was too large to fit in a `long`");
    }

    private void setAdditionalBytesNeeded(long value, boolean isUnannotated) {
        if (isUnannotated) {
            this.additionalBytesNeeded = value;
        }
    }

    private ReadTypeIdResult readTypeID(boolean isUnannotated) throws Exception {
        int header = this.readByte();
        if (header < 0) {
            return ReadTypeIdResult.NO_DATA;
        }
        this.valueTid = IonTypeID.TYPE_IDS[header];
        this.dataHandler.onData(1);
        if (header == 224) {
            if (!isUnannotated) {
                throw new IonException("Invalid annotation header.");
            }
            this.additionalBytesNeeded = 3L;
            this.isSystemValue = true;
            this.resetSymbolTableMarkers();
            this.ivmSecondByteIndex = this.peekIndex;
            this.state = State.SKIPPING_VALUE;
        } else {
            if (!this.valueTid.isValid) {
                throw new IonException("Invalid type ID.");
            }
            if (this.valueTid.type == IonType.BOOL) {
                this.state = State.BEFORE_TYPE_ID;
            } else if (this.valueTid.type == IonTypeID.ION_TYPE_ANNOTATION_WRAPPER) {
                if (this.valueTid.variableLength) {
                    this.initializeVarUInt(VarUInt.Location.ANNOTATION_WRAPPER_LENGTH);
                } else {
                    this.setAdditionalBytesNeeded(this.valueTid.length, isUnannotated);
                    this.initializeVarUInt(VarUInt.Location.ANNOTATION_WRAPPER_SIDS_LENGTH);
                }
            } else if (this.valueTid.isNull) {
                this.state = State.BEFORE_TYPE_ID;
            } else if (this.valueTid.variableLength) {
                this.initializeVarUInt(VarUInt.Location.VALUE_LENGTH);
            } else {
                this.setAdditionalBytesNeeded(this.valueTid.length, isUnannotated);
                this.state = State.SKIPPING_VALUE;
            }
        }
        if (this.valueTid.type == IonType.STRUCT) {
            return ReadTypeIdResult.STRUCT;
        }
        return ReadTypeIdResult.NOT_STRUCT;
    }

    private void readHeader() throws Exception {
        if (this.inProgressVarUInt.location == VarUInt.Location.VALUE_LENGTH) {
            this.readVarUInt();
            if (this.inProgressVarUInt.isComplete) {
                this.additionalBytesNeeded = this.inProgressVarUInt.value;
                this.state = State.SKIPPING_VALUE;
            }
            return;
        }
        if (this.inProgressVarUInt.location == VarUInt.Location.ANNOTATION_WRAPPER_LENGTH) {
            this.readVarUInt();
            if (!this.inProgressVarUInt.isComplete) {
                return;
            }
            this.additionalBytesNeeded = this.inProgressVarUInt.value;
            this.initializeVarUInt(VarUInt.Location.ANNOTATION_WRAPPER_SIDS_LENGTH);
        }
        if (this.inProgressVarUInt.location == VarUInt.Location.ANNOTATION_WRAPPER_SIDS_LENGTH) {
            this.readVarUInt();
            if (!this.inProgressVarUInt.isComplete) {
                return;
            }
            this.additionalBytesNeeded -= (long)this.inProgressVarUInt.numberOfBytesRead;
            this.numberOfAnnotationSidBytesRemaining = this.inProgressVarUInt.value;
            this.initializeVarUInt(VarUInt.Location.ANNOTATION_WRAPPER_SID);
            this.annotationSidsMarker.startIndex = this.peekIndex;
            this.annotationSidsMarker.endIndex = this.annotationSidsMarker.startIndex + (int)this.numberOfAnnotationSidBytesRemaining;
        }
        if (this.inProgressVarUInt.location == VarUInt.Location.ANNOTATION_WRAPPER_SID) {
            this.readVarUInt();
            if (this.inProgressVarUInt.isComplete) {
                this.numberOfAnnotationSidBytesRemaining -= (long)this.inProgressVarUInt.numberOfBytesRead;
                this.additionalBytesNeeded -= (long)this.inProgressVarUInt.numberOfBytesRead;
                this.state = this.inProgressVarUInt.value == 3L ? State.READING_VALUE_WITH_SYMBOL_TABLE_ANNOTATION : State.SKIPPING_VALUE;
            }
        }
    }

    private void shiftIndicesLeft(int afterIndex, int shiftAmount) {
        this.peekIndex = Math.max(this.peekIndex - shiftAmount, 0);
        this.valuePreHeaderIndex -= shiftAmount;
        this.valuePostHeaderIndex -= shiftAmount;
        this.valueStartWriteIndex -= shiftAmount;
        for (Marker symbolTableMarker : this.symbolTableMarkers) {
            if (symbolTableMarker.startIndex <= afterIndex) continue;
            symbolTableMarker.startIndex -= shiftAmount;
            symbolTableMarker.endIndex -= shiftAmount;
        }
        if (this.annotationSidsMarker.startIndex > afterIndex) {
            this.annotationSidsMarker.startIndex -= shiftAmount;
            this.annotationSidsMarker.endIndex -= shiftAmount;
        }
        if (this.ivmSecondByteIndex > afterIndex) {
            this.ivmSecondByteIndex -= shiftAmount;
        }
    }

    private void reclaimNopPadding() {
        this.pipe.consolidate(this.valuePreHeaderIndex, this.nopPadStartIndex);
        this.shiftIndicesLeft(this.nopPadStartIndex, this.valuePreHeaderIndex - this.nopPadStartIndex);
        this.resetNopPadIndex();
    }

    private long skipBytesFromInput(long numberOfBytesToSkip) throws IOException {
        try {
            return this.getInput().skip(numberOfBytesToSkip);
        }
        catch (EOFException e) {
            return 0L;
        }
    }

    private int fillPage(int numberOfBytesRequested) throws Exception {
        int amountToFill = this.pipe.capacity() - this.pipe.size();
        if (amountToFill <= 0) {
            int spaceAvailable = this.getMaximumBufferSize() - this.pipe.capacity();
            if (numberOfBytesRequested > spaceAvailable) {
                if (this.nopPadStartIndex > -1 && this.valuePreHeaderIndex - this.nopPadStartIndex >= numberOfBytesRequested) {
                    this.reclaimNopPadding();
                } else {
                    this.startSkippingValue();
                }
                amountToFill = numberOfBytesRequested;
            } else {
                amountToFill = Math.min(this.pageSize, spaceAvailable);
            }
        }
        int received = this.isSkippingCurrentValue() ? (this.state == State.SKIPPING_VALUE ? (int)this.skipBytesFromInput(amountToFill) : amountToFill) : this.pipe.receive(this.getInput(), amountToFill);
        return received;
    }

    private void notifyHandlerOfOversizedValue() throws Exception {
        if (this.handlerNeedsToBeNotifiedOfOversizedValue) {
            if (this.isSystemValue) {
                this.oversizedSymbolTableHandler.onOversizedSymbolTable();
            } else {
                this.oversizedValueHandler.onOversizedValue();
            }
        }
        this.handlerNeedsToBeNotifiedOfOversizedValue = false;
    }

    private long fillOrSkip() throws Exception {
        long bytesFilled;
        long bytesRequested = this.additionalBytesNeeded - (long)this.pipe.availableBeyondBoundary();
        if (this.isSkippingCurrentValue()) {
            bytesFilled = this.skipBytesFromInput(bytesRequested);
        } else {
            if (this.additionalBytesNeeded > Integer.MAX_VALUE) {
                throw new IonException("The size of the value exceeds the limits of the implementation.");
            }
            bytesFilled = this.fillPage((int)bytesRequested);
        }
        if (bytesFilled < 1L) {
            return 0L;
        }
        if (this.isSkippingCurrentValue()) {
            this.notifyHandlerOfOversizedValue();
            bytesFilled += (long)((int)this.additionalBytesNeeded) - bytesRequested;
        } else {
            bytesFilled = Math.min(this.additionalBytesNeeded, bytesFilled);
            this.pipe.extendBoundary((int)bytesFilled);
            this.peekIndex += (int)bytesFilled;
        }
        return bytesFilled;
    }

    private long skip(long numberOfBytesToSkip) throws Exception {
        long numberOfBytesSkipped;
        if ((long)this.pipe.availableBeyondBoundary() >= numberOfBytesToSkip) {
            numberOfBytesSkipped = (int)numberOfBytesToSkip;
            this.pipe.extendBoundary((int)numberOfBytesSkipped);
            this.peekIndex += (int)numberOfBytesSkipped;
        } else {
            numberOfBytesSkipped = this.fillOrSkip();
        }
        if (numberOfBytesSkipped > 0L) {
            int numberOfBytesToReportThisIteration;
            for (long numberOfBytesToReport = numberOfBytesSkipped; numberOfBytesToReport > 0L; numberOfBytesToReport -= (long)numberOfBytesToReportThisIteration) {
                numberOfBytesToReportThisIteration = (int)Math.min(Integer.MAX_VALUE, numberOfBytesToReport);
                this.dataHandler.onData(numberOfBytesToReportThisIteration);
            }
        }
        return numberOfBytesSkipped;
    }

    @Override
    protected void fillInputHelper() throws Exception {
        while (true) {
            if (this.state == State.BEFORE_TYPE_ID || this.state == State.READING_TYPE_ID) {
                this.reset();
                this.state = State.READING_TYPE_ID;
                if (this.readTypeID(true) != ReadTypeIdResult.NO_DATA) {
                    this.valuePostHeaderIndex = this.peekIndex;
                    this.valueStartWriteIndex = this.valuePreHeaderIndex = this.valuePostHeaderIndex - 1;
                }
            }
            if (this.state == State.READING_HEADER) {
                this.readHeader();
                if (!this.inProgressVarUInt.isComplete) {
                    return;
                }
                this.valuePostHeaderIndex = this.peekIndex;
            }
            if (this.state == State.READING_VALUE_WITH_SYMBOL_TABLE_ANNOTATION) {
                while (this.numberOfAnnotationSidBytesRemaining > 0L) {
                    long numberOfBytesSkipped = this.skip(this.numberOfAnnotationSidBytesRemaining);
                    if (numberOfBytesSkipped < 1L) {
                        return;
                    }
                    this.numberOfAnnotationSidBytesRemaining -= numberOfBytesSkipped;
                    this.additionalBytesNeeded -= numberOfBytesSkipped;
                }
                ReadTypeIdResult result = this.readTypeID(false);
                if (result == ReadTypeIdResult.NO_DATA) {
                    return;
                }
                --this.additionalBytesNeeded;
                this.state = result == ReadTypeIdResult.STRUCT ? State.READING_SYMBOL_TABLE_LENGTH : State.SKIPPING_VALUE;
            }
            if (this.state == State.READING_SYMBOL_TABLE_LENGTH) {
                this.isSystemValue = true;
                if (this.inProgressVarUInt.location == VarUInt.Location.VALUE_LENGTH) {
                    this.readVarUInt();
                    if (!this.inProgressVarUInt.isComplete) {
                        return;
                    }
                    this.additionalBytesNeeded = this.inProgressVarUInt.value;
                }
                this.symbolTableMarkers.add(new Marker(this.peekIndex, (int)this.additionalBytesNeeded));
                this.state = State.SKIPPING_VALUE;
            }
            if (this.state == State.SKIPPING_VALUE) {
                if (this.valueTid.isNopPad && (long)this.pipe.availableBeyondBoundary() <= this.additionalBytesNeeded) {
                    this.additionalBytesNeeded -= (long)this.pipe.availableBeyondBoundary();
                    this.startSkippingValue();
                    this.handlerNeedsToBeNotifiedOfOversizedValue = false;
                }
                while (this.additionalBytesNeeded > 0L) {
                    long numberOfBytesSkipped = this.skip(this.additionalBytesNeeded);
                    if (numberOfBytesSkipped < 1L) {
                        return;
                    }
                    this.additionalBytesNeeded -= numberOfBytesSkipped;
                }
                this.state = State.BEFORE_TYPE_ID;
            }
            if (this.state != State.BEFORE_TYPE_ID) break;
            this.valueEndIndex = this.peekIndex;
            if (!this.isSystemValue && !this.isSkippingCurrentValue() && !this.valueTid.isNopPad) break;
            if (this.valueTid.isNopPad && this.nopPadStartIndex < 0) {
                this.nopPadStartIndex = this.valuePreHeaderIndex;
            }
            if (this.isSystemValue && this.isSkippingCurrentValue()) {
                this.reset();
                this.state = State.DONE;
                break;
            }
            if (!this.isSystemValue || this.nopPadStartIndex <= -1) continue;
            this.reclaimNopPadding();
        }
    }

    @Override
    void truncateToEndOfPreviousValue() {
        this.peekIndex = this.valueStartWriteIndex;
        this.pipe.truncate(this.valueStartWriteIndex, this.valueStartAvailable);
        this.handlerNeedsToBeNotifiedOfOversizedValue = true;
    }

    @Override
    public boolean moreDataRequired() {
        return this.pipe.available() <= 0 || this.state != State.BEFORE_TYPE_ID;
    }

    public void rewindToValueStart() {
        if (this.valuePreHeaderIndex < 0) {
            throw new IllegalStateException("A value must be buffered before calling rewindToValueStart().");
        }
        int availableAtValueStart = this.pipe.getBoundary() - this.valuePreHeaderIndex;
        if (availableAtValueStart < this.available()) {
            throw new IllegalStateException("IonReader.next() must be called on the current value before calling rewindToValueStart().");
        }
        this.pipe.rewind(this.valuePreHeaderIndex, availableAtValueStart);
        this.peekIndex = this.valuePreHeaderIndex;
    }

    int getIvmIndex() {
        return this.ivmSecondByteIndex;
    }

    void resetIvmIndex() {
        this.ivmSecondByteIndex = -1;
    }

    void resetNopPadIndex() {
        this.nopPadStartIndex = -1;
    }

    int getValueStart() {
        if (this.hasAnnotations()) {
            return this.annotationSidsMarker.endIndex;
        }
        return this.valuePostHeaderIndex;
    }

    IonTypeID getValueTid() {
        return this.valueTid;
    }

    int getValueEnd() {
        return this.valueEndIndex;
    }

    List<Marker> getSymbolTableMarkers() {
        return this.symbolTableMarkers;
    }

    void resetSymbolTableMarkers() {
        this.symbolTableMarkers.clear();
    }

    boolean hasAnnotations() {
        return this.annotationSidsMarker.startIndex >= 0;
    }

    Marker getAnnotationSidsMarker() {
        return this.annotationSidsMarker;
    }

    static class Marker {
        int startIndex;
        int endIndex;

        private Marker(int startIndex, int length) {
            this.startIndex = startIndex;
            this.endIndex = startIndex + length;
        }
    }

    private static enum State {
        BEFORE_TYPE_ID,
        READING_TYPE_ID,
        READING_HEADER,
        SKIPPING_VALUE,
        READING_VALUE_WITH_SYMBOL_TABLE_ANNOTATION,
        READING_SYMBOL_TABLE_LENGTH,
        DONE;

    }

    private static final class VarUInt {
        private Location location;
        private long value;
        private int numberOfBytesRead;
        private boolean isComplete;

        private VarUInt() {
            this.reset(Location.VALUE_LENGTH);
        }

        private void reset(Location nextLocation) {
            this.location = nextLocation;
            this.value = 0L;
            this.numberOfBytesRead = 0;
            this.isComplete = false;
        }

        private static enum Location {
            VALUE_LENGTH,
            ANNOTATION_WRAPPER_LENGTH,
            ANNOTATION_WRAPPER_SIDS_LENGTH,
            ANNOTATION_WRAPPER_SID;

        }
    }

    private static enum ReadTypeIdResult {
        STRUCT,
        NOT_STRUCT,
        NO_DATA;

    }
}

