/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;

final class UnmarshallUtils {
    static final String HEADER_FIELD_NAME = "header";
    static final String NAMESPACE_FIELD_NAME = "namespace";
    static final String NAME_FIELD_NAME = "name";

    private UnmarshallUtils() {
    }

    static Optional<String> getNamespaceDiscriminator(JsonNode root) {
        if (!root.has(HEADER_FIELD_NAME)) {
            return Optional.empty();
        }
        JsonNode header = root.get(HEADER_FIELD_NAME);
        if (!header.has(NAMESPACE_FIELD_NAME) || !header.get(NAMESPACE_FIELD_NAME).isTextual()) {
            return Optional.empty();
        }
        if (!header.has(NAME_FIELD_NAME) || !header.get(NAME_FIELD_NAME).isTextual()) {
            return Optional.empty();
        }
        String targetNamespace = header.get(NAMESPACE_FIELD_NAME).asText();
        String targetName = header.get(NAME_FIELD_NAME).asText();
        return Optional.of(targetNamespace + "." + targetName);
    }
}

