/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response.template.loader.impl;

import com.amazon.ask.response.template.TemplateContentData;
import com.amazon.ask.util.ValidationUtils;

public class AccessOrderedTemplateContentData {
    protected final TemplateContentData templateContentData;
    private long accessTimestamp;

    public AccessOrderedTemplateContentData(TemplateContentData templateContentData) {
        this.templateContentData = ValidationUtils.assertNotNull(templateContentData, "templateContentData");
        this.accessTimestamp = System.currentTimeMillis();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getAccessTimestamp() {
        return this.accessTimestamp;
    }

    public TemplateContentData getTemplateContentData() {
        this.updateTimestamp();
        return this.templateContentData;
    }

    private void updateTimestamp() {
        this.accessTimestamp = System.currentTimeMillis();
    }

    public static final class Builder {
        private TemplateContentData templateContentData;

        public Builder withTemplateContentData(TemplateContentData templateContentData) {
            this.templateContentData = templateContentData;
            return this;
        }

        public AccessOrderedTemplateContentData build() {
            return new AccessOrderedTemplateContentData(this.templateContentData);
        }
    }
}

