/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.ups;

import com.amazon.ask.model.services.ups.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Error {
    @JsonProperty(value="code")
    private String code = null;
    @JsonProperty(value="message")
    private String message = null;

    private Error() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Error(Builder builder) {
        if (builder.code != null) {
            this.code = builder.code;
        }
        if (builder.message != null) {
            this.message = builder.message;
        }
    }

    public ErrorCode getCode() {
        return ErrorCode.fromValue(this.code);
    }

    @JsonProperty(value="code")
    public String getCodeAsString() {
        return this.code;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error servicesUpsError = (Error)o;
        return Objects.equals(this.code, servicesUpsError.code) && Objects.equals(this.message, servicesUpsError.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String code;
        private String message;

        private Builder() {
        }

        @JsonProperty(value="code")
        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withCode(ErrorCode code) {
            this.code = code != null ? code.toString() : null;
            return this;
        }

        @JsonProperty(value="message")
        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Error build() {
            return new Error(this);
        }
    }
}

