/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ResponsePaginationContext {
    @JsonProperty(value="totalCount")
    private Integer totalCount = null;
    @JsonProperty(value="previousToken")
    private String previousToken = null;
    @JsonProperty(value="nextToken")
    private String nextToken = null;

    private ResponsePaginationContext() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResponsePaginationContext(Builder builder) {
        if (builder.totalCount != null) {
            this.totalCount = builder.totalCount;
        }
        if (builder.previousToken != null) {
            this.previousToken = builder.previousToken;
        }
        if (builder.nextToken != null) {
            this.nextToken = builder.nextToken;
        }
    }

    @JsonProperty(value="totalCount")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="previousToken")
    public String getPreviousToken() {
        return this.previousToken;
    }

    @JsonProperty(value="nextToken")
    public String getNextToken() {
        return this.nextToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponsePaginationContext servicesDatastoreV1ResponsePaginationContext = (ResponsePaginationContext)o;
        return Objects.equals(this.totalCount, servicesDatastoreV1ResponsePaginationContext.totalCount) && Objects.equals(this.previousToken, servicesDatastoreV1ResponsePaginationContext.previousToken) && Objects.equals(this.nextToken, servicesDatastoreV1ResponsePaginationContext.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.previousToken, this.nextToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponsePaginationContext {\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    previousToken: ").append(this.toIndentedString(this.previousToken)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer totalCount;
        private String previousToken;
        private String nextToken;

        private Builder() {
        }

        @JsonProperty(value="totalCount")
        public Builder withTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @JsonProperty(value="previousToken")
        public Builder withPreviousToken(String previousToken) {
            this.previousToken = previousToken;
            return this;
        }

        @JsonProperty(value="nextToken")
        public Builder withNextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public ResponsePaginationContext build() {
            return new ResponsePaginationContext(this);
        }
    }
}

