/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.datastore.v1;

import com.amazon.ask.model.services.datastore.v1.CommandsDispatchResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CommandsResponse {
    @JsonProperty(value="results")
    private List<CommandsDispatchResult> results = new ArrayList<CommandsDispatchResult>();
    @JsonProperty(value="queuedResultId")
    private String queuedResultId = null;

    private CommandsResponse() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CommandsResponse(Builder builder) {
        if (builder.results != null) {
            this.results = builder.results;
        }
        if (builder.queuedResultId != null) {
            this.queuedResultId = builder.queuedResultId;
        }
    }

    @JsonProperty(value="results")
    public List<CommandsDispatchResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="queuedResultId")
    public String getQueuedResultId() {
        return this.queuedResultId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandsResponse servicesDatastoreV1CommandsResponse = (CommandsResponse)o;
        return Objects.equals(this.results, servicesDatastoreV1CommandsResponse.results) && Objects.equals(this.queuedResultId, servicesDatastoreV1CommandsResponse.queuedResultId);
    }

    public int hashCode() {
        return Objects.hash(this.results, this.queuedResultId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommandsResponse {\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    queuedResultId: ").append(this.toIndentedString(this.queuedResultId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<CommandsDispatchResult> results;
        private String queuedResultId;

        private Builder() {
        }

        @JsonProperty(value="results")
        public Builder withResults(List<CommandsDispatchResult> results) {
            this.results = results;
            return this;
        }

        public Builder addResultsItem(CommandsDispatchResult resultsItem) {
            if (this.results == null) {
                this.results = new ArrayList<CommandsDispatchResult>();
            }
            this.results.add(resultsItem);
            return this;
        }

        @JsonProperty(value="queuedResultId")
        public Builder withQueuedResultId(String queuedResultId) {
            this.queuedResultId = queuedResultId;
            return this;
        }

        public CommandsResponse build() {
            return new CommandsResponse(this);
        }
    }
}

