/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.amazonpay.model.v1;

import com.amazon.ask.model.interfaces.amazonpay.model.v1.BillingAgreementType;
import com.amazon.ask.model.interfaces.amazonpay.model.v1.Price;
import com.amazon.ask.model.interfaces.amazonpay.model.v1.SellerBillingAgreementAttributes;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class BillingAgreementAttributes {
    @JsonProperty(value="platformId")
    private String platformId = null;
    @JsonProperty(value="sellerNote")
    private String sellerNote = null;
    @JsonProperty(value="sellerBillingAgreementAttributes")
    private SellerBillingAgreementAttributes sellerBillingAgreementAttributes = null;
    @JsonProperty(value="billingAgreementType")
    private String billingAgreementType = null;
    @JsonProperty(value="subscriptionAmount")
    private Price subscriptionAmount = null;

    private BillingAgreementAttributes() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private BillingAgreementAttributes(Builder builder) {
        if (builder.platformId != null) {
            this.platformId = builder.platformId;
        }
        if (builder.sellerNote != null) {
            this.sellerNote = builder.sellerNote;
        }
        if (builder.sellerBillingAgreementAttributes != null) {
            this.sellerBillingAgreementAttributes = builder.sellerBillingAgreementAttributes;
        }
        if (builder.billingAgreementType != null) {
            this.billingAgreementType = builder.billingAgreementType;
        }
        if (builder.subscriptionAmount != null) {
            this.subscriptionAmount = builder.subscriptionAmount;
        }
    }

    @JsonProperty(value="platformId")
    public String getPlatformId() {
        return this.platformId;
    }

    @JsonProperty(value="sellerNote")
    public String getSellerNote() {
        return this.sellerNote;
    }

    @JsonProperty(value="sellerBillingAgreementAttributes")
    public SellerBillingAgreementAttributes getSellerBillingAgreementAttributes() {
        return this.sellerBillingAgreementAttributes;
    }

    public BillingAgreementType getBillingAgreementType() {
        return BillingAgreementType.fromValue(this.billingAgreementType);
    }

    @JsonProperty(value="billingAgreementType")
    public String getBillingAgreementTypeAsString() {
        return this.billingAgreementType;
    }

    @JsonProperty(value="subscriptionAmount")
    public Price getSubscriptionAmount() {
        return this.subscriptionAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingAgreementAttributes interfacesAmazonpayModelV1BillingAgreementAttributes = (BillingAgreementAttributes)o;
        return Objects.equals(this.platformId, interfacesAmazonpayModelV1BillingAgreementAttributes.platformId) && Objects.equals(this.sellerNote, interfacesAmazonpayModelV1BillingAgreementAttributes.sellerNote) && Objects.equals(this.sellerBillingAgreementAttributes, interfacesAmazonpayModelV1BillingAgreementAttributes.sellerBillingAgreementAttributes) && Objects.equals(this.billingAgreementType, interfacesAmazonpayModelV1BillingAgreementAttributes.billingAgreementType) && Objects.equals(this.subscriptionAmount, interfacesAmazonpayModelV1BillingAgreementAttributes.subscriptionAmount);
    }

    public int hashCode() {
        return Objects.hash(this.platformId, this.sellerNote, this.sellerBillingAgreementAttributes, this.billingAgreementType, this.subscriptionAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingAgreementAttributes {\n");
        sb.append("    platformId: ").append(this.toIndentedString(this.platformId)).append("\n");
        sb.append("    sellerNote: ").append(this.toIndentedString(this.sellerNote)).append("\n");
        sb.append("    sellerBillingAgreementAttributes: ").append(this.toIndentedString(this.sellerBillingAgreementAttributes)).append("\n");
        sb.append("    billingAgreementType: ").append(this.toIndentedString(this.billingAgreementType)).append("\n");
        sb.append("    subscriptionAmount: ").append(this.toIndentedString(this.subscriptionAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String platformId;
        private String sellerNote;
        private SellerBillingAgreementAttributes sellerBillingAgreementAttributes;
        private String billingAgreementType;
        private Price subscriptionAmount;

        private Builder() {
        }

        @JsonProperty(value="platformId")
        public Builder withPlatformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        @JsonProperty(value="sellerNote")
        public Builder withSellerNote(String sellerNote) {
            this.sellerNote = sellerNote;
            return this;
        }

        @JsonProperty(value="sellerBillingAgreementAttributes")
        public Builder withSellerBillingAgreementAttributes(SellerBillingAgreementAttributes sellerBillingAgreementAttributes) {
            this.sellerBillingAgreementAttributes = sellerBillingAgreementAttributes;
            return this;
        }

        @JsonProperty(value="billingAgreementType")
        public Builder withBillingAgreementType(String billingAgreementType) {
            this.billingAgreementType = billingAgreementType;
            return this;
        }

        public Builder withBillingAgreementType(BillingAgreementType billingAgreementType) {
            this.billingAgreementType = billingAgreementType != null ? billingAgreementType.toString() : null;
            return this;
        }

        @JsonProperty(value="subscriptionAmount")
        public Builder withSubscriptionAmount(Price subscriptionAmount) {
            this.subscriptionAmount = subscriptionAmount;
            return this;
        }

        public BillingAgreementAttributes build() {
            return new BillingAgreementAttributes(this);
        }
    }
}

