/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Context;
import com.amazon.ask.model.Request;
import com.amazon.ask.model.Session;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class RequestEnvelope {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="session")
    private Session session = null;
    @JsonProperty(value="context")
    private Context context = null;
    @JsonProperty(value="request")
    private Request request = null;

    private RequestEnvelope() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RequestEnvelope(Builder builder) {
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.session != null) {
            this.session = builder.session;
        }
        if (builder.context != null) {
            this.context = builder.context;
        }
        if (builder.request != null) {
            this.request = builder.request;
        }
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="session")
    public Session getSession() {
        return this.session;
    }

    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="request")
    public Request getRequest() {
        return this.request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestEnvelope requestEnvelope = (RequestEnvelope)o;
        return Objects.equals(this.version, requestEnvelope.version) && Objects.equals(this.session, requestEnvelope.session) && Objects.equals(this.context, requestEnvelope.context) && Objects.equals(this.request, requestEnvelope.request);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.session, this.context, this.request);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestEnvelope {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private Session session;
        private Context context;
        private Request request;

        private Builder() {
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="session")
        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        @JsonProperty(value="context")
        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        @JsonProperty(value="request")
        public Builder withRequest(Request request) {
            this.request = request;
            return this;
        }

        public RequestEnvelope build() {
            return new RequestEnvelope(this);
        }
    }
}

