/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.interfaces.alexa.datastore.packagemanager.PackageManagerState;
import com.amazon.ask.model.interfaces.alexa.experimentation.ExperimentationState;
import com.amazon.ask.model.interfaces.alexa.extension.ExtensionsState;
import com.amazon.ask.model.interfaces.alexa.presentation.PresentationState;
import com.amazon.ask.model.interfaces.alexa.presentation.apl.RenderedDocumentState;
import com.amazon.ask.model.interfaces.applink.AppLinkState;
import com.amazon.ask.model.interfaces.audioplayer.AudioPlayerState;
import com.amazon.ask.model.interfaces.automotive.AutomotiveState;
import com.amazon.ask.model.interfaces.display.DisplayState;
import com.amazon.ask.model.interfaces.geolocation.GeolocationState;
import com.amazon.ask.model.interfaces.system.SystemState;
import com.amazon.ask.model.interfaces.viewport.TypedViewportState;
import com.amazon.ask.model.interfaces.viewport.ViewportState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Context {
    @JsonProperty(value="System")
    private SystemState system = null;
    @JsonProperty(value="Alexa.Presentation")
    private PresentationState alexaPresentation = null;
    @JsonProperty(value="Alexa.Presentation.APL")
    private RenderedDocumentState alexaPresentationAPL = null;
    @JsonProperty(value="AudioPlayer")
    private AudioPlayerState audioPlayer = null;
    @JsonProperty(value="Automotive")
    private AutomotiveState automotive = null;
    @JsonProperty(value="Display")
    private DisplayState display = null;
    @JsonProperty(value="Geolocation")
    private GeolocationState geolocation = null;
    @JsonProperty(value="Viewport")
    private ViewportState viewport = null;
    @JsonProperty(value="Viewports")
    private List<TypedViewportState> viewports = new ArrayList<TypedViewportState>();
    @JsonProperty(value="Extensions")
    private ExtensionsState extensions = null;
    @JsonProperty(value="Alexa.DataStore.PackageManager")
    private PackageManagerState alexaDataStorePackageManager = null;
    @JsonProperty(value="AppLink")
    private AppLinkState appLink = null;
    @JsonProperty(value="Experimentation")
    private ExperimentationState experimentation = null;

    private Context() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Context(Builder builder) {
        if (builder.system != null) {
            this.system = builder.system;
        }
        if (builder.alexaPresentation != null) {
            this.alexaPresentation = builder.alexaPresentation;
        }
        if (builder.alexaPresentationAPL != null) {
            this.alexaPresentationAPL = builder.alexaPresentationAPL;
        }
        if (builder.audioPlayer != null) {
            this.audioPlayer = builder.audioPlayer;
        }
        if (builder.automotive != null) {
            this.automotive = builder.automotive;
        }
        if (builder.display != null) {
            this.display = builder.display;
        }
        if (builder.geolocation != null) {
            this.geolocation = builder.geolocation;
        }
        if (builder.viewport != null) {
            this.viewport = builder.viewport;
        }
        if (builder.viewports != null) {
            this.viewports = builder.viewports;
        }
        if (builder.extensions != null) {
            this.extensions = builder.extensions;
        }
        if (builder.alexaDataStorePackageManager != null) {
            this.alexaDataStorePackageManager = builder.alexaDataStorePackageManager;
        }
        if (builder.appLink != null) {
            this.appLink = builder.appLink;
        }
        if (builder.experimentation != null) {
            this.experimentation = builder.experimentation;
        }
    }

    @JsonProperty(value="System")
    public SystemState getSystem() {
        return this.system;
    }

    @JsonProperty(value="Alexa.Presentation")
    public PresentationState getAlexaPresentation() {
        return this.alexaPresentation;
    }

    @JsonProperty(value="Alexa.Presentation.APL")
    public RenderedDocumentState getAlexaPresentationAPL() {
        return this.alexaPresentationAPL;
    }

    @JsonProperty(value="AudioPlayer")
    public AudioPlayerState getAudioPlayer() {
        return this.audioPlayer;
    }

    @JsonProperty(value="Automotive")
    public AutomotiveState getAutomotive() {
        return this.automotive;
    }

    @JsonProperty(value="Display")
    public DisplayState getDisplay() {
        return this.display;
    }

    @JsonProperty(value="Geolocation")
    public GeolocationState getGeolocation() {
        return this.geolocation;
    }

    @JsonProperty(value="Viewport")
    public ViewportState getViewport() {
        return this.viewport;
    }

    @JsonProperty(value="Viewports")
    public List<TypedViewportState> getViewports() {
        return this.viewports;
    }

    @JsonProperty(value="Extensions")
    public ExtensionsState getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="Alexa.DataStore.PackageManager")
    public PackageManagerState getAlexaDataStorePackageManager() {
        return this.alexaDataStorePackageManager;
    }

    @JsonProperty(value="AppLink")
    public AppLinkState getAppLink() {
        return this.appLink;
    }

    @JsonProperty(value="Experimentation")
    public ExperimentationState getExperimentation() {
        return this.experimentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.system, context.system) && Objects.equals(this.alexaPresentation, context.alexaPresentation) && Objects.equals(this.alexaPresentationAPL, context.alexaPresentationAPL) && Objects.equals(this.audioPlayer, context.audioPlayer) && Objects.equals(this.automotive, context.automotive) && Objects.equals(this.display, context.display) && Objects.equals(this.geolocation, context.geolocation) && Objects.equals(this.viewport, context.viewport) && Objects.equals(this.viewports, context.viewports) && Objects.equals(this.extensions, context.extensions) && Objects.equals(this.alexaDataStorePackageManager, context.alexaDataStorePackageManager) && Objects.equals(this.appLink, context.appLink) && Objects.equals(this.experimentation, context.experimentation);
    }

    public int hashCode() {
        return Objects.hash(this.system, this.alexaPresentation, this.alexaPresentationAPL, this.audioPlayer, this.automotive, this.display, this.geolocation, this.viewport, this.viewports, this.extensions, this.alexaDataStorePackageManager, this.appLink, this.experimentation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Context {\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    alexaPresentation: ").append(this.toIndentedString(this.alexaPresentation)).append("\n");
        sb.append("    alexaPresentationAPL: ").append(this.toIndentedString(this.alexaPresentationAPL)).append("\n");
        sb.append("    audioPlayer: ").append(this.toIndentedString(this.audioPlayer)).append("\n");
        sb.append("    automotive: ").append(this.toIndentedString(this.automotive)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    viewport: ").append(this.toIndentedString(this.viewport)).append("\n");
        sb.append("    viewports: ").append(this.toIndentedString(this.viewports)).append("\n");
        sb.append("    extensions: ").append(this.toIndentedString(this.extensions)).append("\n");
        sb.append("    alexaDataStorePackageManager: ").append(this.toIndentedString(this.alexaDataStorePackageManager)).append("\n");
        sb.append("    appLink: ").append(this.toIndentedString(this.appLink)).append("\n");
        sb.append("    experimentation: ").append(this.toIndentedString(this.experimentation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private SystemState system;
        private PresentationState alexaPresentation;
        private RenderedDocumentState alexaPresentationAPL;
        private AudioPlayerState audioPlayer;
        private AutomotiveState automotive;
        private DisplayState display;
        private GeolocationState geolocation;
        private ViewportState viewport;
        private List<TypedViewportState> viewports;
        private ExtensionsState extensions;
        private PackageManagerState alexaDataStorePackageManager;
        private AppLinkState appLink;
        private ExperimentationState experimentation;

        private Builder() {
        }

        @JsonProperty(value="System")
        public Builder withSystem(SystemState system) {
            this.system = system;
            return this;
        }

        @JsonProperty(value="Alexa.Presentation")
        public Builder withAlexaPresentation(PresentationState alexaPresentation) {
            this.alexaPresentation = alexaPresentation;
            return this;
        }

        @JsonProperty(value="Alexa.Presentation.APL")
        public Builder withAlexaPresentationAPL(RenderedDocumentState alexaPresentationAPL) {
            this.alexaPresentationAPL = alexaPresentationAPL;
            return this;
        }

        @JsonProperty(value="AudioPlayer")
        public Builder withAudioPlayer(AudioPlayerState audioPlayer) {
            this.audioPlayer = audioPlayer;
            return this;
        }

        @JsonProperty(value="Automotive")
        public Builder withAutomotive(AutomotiveState automotive) {
            this.automotive = automotive;
            return this;
        }

        @JsonProperty(value="Display")
        public Builder withDisplay(DisplayState display) {
            this.display = display;
            return this;
        }

        @JsonProperty(value="Geolocation")
        public Builder withGeolocation(GeolocationState geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        @JsonProperty(value="Viewport")
        public Builder withViewport(ViewportState viewport) {
            this.viewport = viewport;
            return this;
        }

        @JsonProperty(value="Viewports")
        public Builder withViewports(List<TypedViewportState> viewports) {
            this.viewports = viewports;
            return this;
        }

        public Builder addViewportsItem(TypedViewportState viewportsItem) {
            if (this.viewports == null) {
                this.viewports = new ArrayList<TypedViewportState>();
            }
            this.viewports.add(viewportsItem);
            return this;
        }

        @JsonProperty(value="Extensions")
        public Builder withExtensions(ExtensionsState extensions) {
            this.extensions = extensions;
            return this;
        }

        @JsonProperty(value="Alexa.DataStore.PackageManager")
        public Builder withAlexaDataStorePackageManager(PackageManagerState alexaDataStorePackageManager) {
            this.alexaDataStorePackageManager = alexaDataStorePackageManager;
            return this;
        }

        @JsonProperty(value="AppLink")
        public Builder withAppLink(AppLinkState appLink) {
            this.appLink = appLink;
            return this;
        }

        @JsonProperty(value="Experimentation")
        public Builder withExperimentation(ExperimentationState experimentation) {
            this.experimentation = experimentation;
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

