/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.timerManagement;

import com.amazon.ask.model.services.timerManagement.TimerResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class TimersResponse {
    @JsonProperty(value="totalCount")
    private Integer totalCount = null;
    @JsonProperty(value="timers")
    private List<TimerResponse> timers = new ArrayList<TimerResponse>();
    @JsonProperty(value="nextToken")
    private String nextToken = null;

    public static Builder builder() {
        return new Builder();
    }

    private TimersResponse(Builder builder) {
        if (builder.totalCount != null) {
            this.totalCount = builder.totalCount;
        }
        if (builder.timers != null) {
            this.timers = builder.timers;
        }
        if (builder.nextToken != null) {
            this.nextToken = builder.nextToken;
        }
    }

    @JsonProperty(value="totalCount")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="timers")
    public List<TimerResponse> getTimers() {
        return this.timers;
    }

    @JsonProperty(value="nextToken")
    public String getNextToken() {
        return this.nextToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimersResponse servicesTimerManagementTimersResponse = (TimersResponse)o;
        return Objects.equals(this.totalCount, servicesTimerManagementTimersResponse.totalCount) && Objects.equals(this.timers, servicesTimerManagementTimersResponse.timers) && Objects.equals(this.nextToken, servicesTimerManagementTimersResponse.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.timers, this.nextToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimersResponse {\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    timers: ").append(this.toIndentedString(this.timers)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer totalCount;
        private List<TimerResponse> timers;
        private String nextToken;

        private Builder() {
        }

        @JsonProperty(value="totalCount")
        public Builder withTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @JsonProperty(value="timers")
        public Builder withTimers(List<TimerResponse> timers) {
            this.timers = timers;
            return this;
        }

        public Builder addTimersItem(TimerResponse timersItem) {
            if (this.timers == null) {
                this.timers = new ArrayList<TimerResponse>();
            }
            this.timers.add(timersItem);
            return this;
        }

        @JsonProperty(value="nextToken")
        public Builder withNextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public TimersResponse build() {
            return new TimersResponse(this);
        }
    }
}

