/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.timerManagement;

import com.amazon.ask.model.services.timerManagement.CreationBehavior;
import com.amazon.ask.model.services.timerManagement.TriggeringBehavior;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class TimerRequest {
    @JsonProperty(value="duration")
    private String duration = null;
    @JsonProperty(value="timerLabel")
    private String timerLabel = null;
    @JsonProperty(value="creationBehavior")
    private CreationBehavior creationBehavior = null;
    @JsonProperty(value="triggeringBehavior")
    private TriggeringBehavior triggeringBehavior = null;

    public static Builder builder() {
        return new Builder();
    }

    private TimerRequest(Builder builder) {
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
        if (builder.timerLabel != null) {
            this.timerLabel = builder.timerLabel;
        }
        if (builder.creationBehavior != null) {
            this.creationBehavior = builder.creationBehavior;
        }
        if (builder.triggeringBehavior != null) {
            this.triggeringBehavior = builder.triggeringBehavior;
        }
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="timerLabel")
    public String getTimerLabel() {
        return this.timerLabel;
    }

    @JsonProperty(value="creationBehavior")
    public CreationBehavior getCreationBehavior() {
        return this.creationBehavior;
    }

    @JsonProperty(value="triggeringBehavior")
    public TriggeringBehavior getTriggeringBehavior() {
        return this.triggeringBehavior;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerRequest servicesTimerManagementTimerRequest = (TimerRequest)o;
        return Objects.equals(this.duration, servicesTimerManagementTimerRequest.duration) && Objects.equals(this.timerLabel, servicesTimerManagementTimerRequest.timerLabel) && Objects.equals(this.creationBehavior, servicesTimerManagementTimerRequest.creationBehavior) && Objects.equals(this.triggeringBehavior, servicesTimerManagementTimerRequest.triggeringBehavior);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.timerLabel, this.creationBehavior, this.triggeringBehavior);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimerRequest {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    timerLabel: ").append(this.toIndentedString(this.timerLabel)).append("\n");
        sb.append("    creationBehavior: ").append(this.toIndentedString(this.creationBehavior)).append("\n");
        sb.append("    triggeringBehavior: ").append(this.toIndentedString(this.triggeringBehavior)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String duration;
        private String timerLabel;
        private CreationBehavior creationBehavior;
        private TriggeringBehavior triggeringBehavior;

        private Builder() {
        }

        @JsonProperty(value="duration")
        public Builder withDuration(String duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="timerLabel")
        public Builder withTimerLabel(String timerLabel) {
            this.timerLabel = timerLabel;
            return this;
        }

        @JsonProperty(value="creationBehavior")
        public Builder withCreationBehavior(CreationBehavior creationBehavior) {
            this.creationBehavior = creationBehavior;
            return this;
        }

        @JsonProperty(value="triggeringBehavior")
        public Builder withTriggeringBehavior(TriggeringBehavior triggeringBehavior) {
            this.triggeringBehavior = triggeringBehavior;
            return this;
        }

        public TimerRequest build() {
            return new TimerRequest(this);
        }
    }
}

