/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.reminderManagement;

import com.amazon.ask.model.services.reminderManagement.Recurrence;
import com.amazon.ask.model.services.reminderManagement.TriggerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Trigger {
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="scheduledTime")
    private LocalDateTime scheduledTime = null;
    @JsonProperty(value="offsetInSeconds")
    private Integer offsetInSeconds = null;
    @JsonProperty(value="timeZoneId")
    private String timeZoneId = null;
    @JsonProperty(value="recurrence")
    private Recurrence recurrence = null;

    public static Builder builder() {
        return new Builder();
    }

    private Trigger(Builder builder) {
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.scheduledTime != null) {
            this.scheduledTime = builder.scheduledTime;
        }
        if (builder.offsetInSeconds != null) {
            this.offsetInSeconds = builder.offsetInSeconds;
        }
        if (builder.timeZoneId != null) {
            this.timeZoneId = builder.timeZoneId;
        }
        if (builder.recurrence != null) {
            this.recurrence = builder.recurrence;
        }
    }

    public TriggerType getType() {
        return TriggerType.fromValue(this.type);
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return this.type;
    }

    @JsonProperty(value="scheduledTime")
    public LocalDateTime getScheduledTime() {
        return this.scheduledTime;
    }

    @JsonProperty(value="offsetInSeconds")
    public Integer getOffsetInSeconds() {
        return this.offsetInSeconds;
    }

    @JsonProperty(value="timeZoneId")
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @JsonProperty(value="recurrence")
    public Recurrence getRecurrence() {
        return this.recurrence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger servicesReminderManagementTrigger = (Trigger)o;
        return Objects.equals(this.type, servicesReminderManagementTrigger.type) && Objects.equals(this.scheduledTime, servicesReminderManagementTrigger.scheduledTime) && Objects.equals(this.offsetInSeconds, servicesReminderManagementTrigger.offsetInSeconds) && Objects.equals(this.timeZoneId, servicesReminderManagementTrigger.timeZoneId) && Objects.equals(this.recurrence, servicesReminderManagementTrigger.recurrence);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.scheduledTime, this.offsetInSeconds, this.timeZoneId, this.recurrence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trigger {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    scheduledTime: ").append(this.toIndentedString(this.scheduledTime)).append("\n");
        sb.append("    offsetInSeconds: ").append(this.toIndentedString(this.offsetInSeconds)).append("\n");
        sb.append("    timeZoneId: ").append(this.toIndentedString(this.timeZoneId)).append("\n");
        sb.append("    recurrence: ").append(this.toIndentedString(this.recurrence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String type;
        private LocalDateTime scheduledTime;
        private Integer offsetInSeconds;
        private String timeZoneId;
        private Recurrence recurrence;

        private Builder() {
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withType(TriggerType type) {
            this.type = type != null ? type.toString() : null;
            return this;
        }

        @JsonProperty(value="scheduledTime")
        public Builder withScheduledTime(LocalDateTime scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        @JsonProperty(value="offsetInSeconds")
        public Builder withOffsetInSeconds(Integer offsetInSeconds) {
            this.offsetInSeconds = offsetInSeconds;
            return this;
        }

        @JsonProperty(value="timeZoneId")
        public Builder withTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        @JsonProperty(value="recurrence")
        public Builder withRecurrence(Recurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public Trigger build() {
            return new Trigger(this);
        }
    }
}

