/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gameEngine;

import com.amazon.ask.model.services.gameEngine.InputEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class InputHandlerEvent {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="inputEvents")
    private List<InputEvent> inputEvents = new ArrayList<InputEvent>();

    public static Builder builder() {
        return new Builder();
    }

    private InputHandlerEvent(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.inputEvents != null) {
            this.inputEvents = builder.inputEvents;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="inputEvents")
    public List<InputEvent> getInputEvents() {
        return this.inputEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputHandlerEvent servicesGameEngineInputHandlerEvent = (InputHandlerEvent)o;
        return Objects.equals(this.name, servicesGameEngineInputHandlerEvent.name) && Objects.equals(this.inputEvents, servicesGameEngineInputHandlerEvent.inputEvents);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inputEvents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputHandlerEvent {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    inputEvents: ").append(this.toIndentedString(this.inputEvents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private List<InputEvent> inputEvents;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="inputEvents")
        public Builder withInputEvents(List<InputEvent> inputEvents) {
            this.inputEvents = inputEvents;
            return this;
        }

        public Builder addInputEventsItem(InputEvent inputEventsItem) {
            if (this.inputEvents == null) {
                this.inputEvents = new ArrayList<InputEvent>();
            }
            this.inputEvents.add(inputEventsItem);
            return this;
        }

        public InputHandlerEvent build() {
            return new InputHandlerEvent(this);
        }
    }
}

