/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.geolocation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Heading {
    @JsonProperty(value="directionInDegrees")
    private Double directionInDegrees = null;
    @JsonProperty(value="accuracyInDegrees")
    private Double accuracyInDegrees = null;

    public static Builder builder() {
        return new Builder();
    }

    private Heading(Builder builder) {
        if (builder.directionInDegrees != null) {
            this.directionInDegrees = builder.directionInDegrees;
        }
        if (builder.accuracyInDegrees != null) {
            this.accuracyInDegrees = builder.accuracyInDegrees;
        }
    }

    @JsonProperty(value="directionInDegrees")
    public Double getDirectionInDegrees() {
        return this.directionInDegrees;
    }

    @JsonProperty(value="accuracyInDegrees")
    public Double getAccuracyInDegrees() {
        return this.accuracyInDegrees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Heading interfacesGeolocationHeading = (Heading)o;
        return Objects.equals(this.directionInDegrees, interfacesGeolocationHeading.directionInDegrees) && Objects.equals(this.accuracyInDegrees, interfacesGeolocationHeading.accuracyInDegrees);
    }

    public int hashCode() {
        return Objects.hash(this.directionInDegrees, this.accuracyInDegrees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Heading {\n");
        sb.append("    directionInDegrees: ").append(this.toIndentedString(this.directionInDegrees)).append("\n");
        sb.append("    accuracyInDegrees: ").append(this.toIndentedString(this.accuracyInDegrees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Double directionInDegrees;
        private Double accuracyInDegrees;

        private Builder() {
        }

        @JsonProperty(value="directionInDegrees")
        public Builder withDirectionInDegrees(Double directionInDegrees) {
            this.directionInDegrees = directionInDegrees;
            return this;
        }

        @JsonProperty(value="accuracyInDegrees")
        public Builder withAccuracyInDegrees(Double accuracyInDegrees) {
            this.accuracyInDegrees = accuracyInDegrees;
            return this;
        }

        public Heading build() {
            return new Heading(this);
        }
    }
}

