/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.customInterfaceController;

import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ExpiredRequest
extends Request {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="expirationPayload")
    private Object expirationPayload = null;

    public static Builder builder() {
        return new Builder();
    }

    private ExpiredRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "CustomInterfaceController.Expired";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.expirationPayload != null) {
            this.expirationPayload = builder.expirationPayload;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="expirationPayload")
    public Object getExpirationPayload() {
        return this.expirationPayload;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpiredRequest interfacesCustomInterfaceControllerExpiredRequest = (ExpiredRequest)o;
        return Objects.equals(this.token, interfacesCustomInterfaceControllerExpiredRequest.token) && Objects.equals(this.expirationPayload, interfacesCustomInterfaceControllerExpiredRequest.expirationPayload) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.token, this.expirationPayload, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpiredRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    expirationPayload: ").append(this.toIndentedString(this.expirationPayload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String token;
        private Object expirationPayload;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="expirationPayload")
        public Builder withExpirationPayload(Object expirationPayload) {
            this.expirationPayload = expirationPayload;
            return this;
        }

        public ExpiredRequest build() {
            return new ExpiredRequest(this);
        }
    }
}

