/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.conversations;

import com.amazon.ask.model.SlotValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class APIRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="arguments")
    private Map<String, Object> arguments = new HashMap<String, Object>();
    @JsonProperty(value="slots")
    private Map<String, SlotValue> slots = new HashMap<String, SlotValue>();

    public static Builder builder() {
        return new Builder();
    }

    private APIRequest(Builder builder) {
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.arguments != null) {
            this.arguments = builder.arguments;
        }
        if (builder.slots != null) {
            this.slots = builder.slots;
        }
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="arguments")
    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="slots")
    public Map<String, SlotValue> getSlots() {
        return this.slots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIRequest interfacesConversationsAPIRequest = (APIRequest)o;
        return Objects.equals(this.name, interfacesConversationsAPIRequest.name) && Objects.equals(this.arguments, interfacesConversationsAPIRequest.arguments) && Objects.equals(this.slots, interfacesConversationsAPIRequest.slots);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.slots);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    slots: ").append(this.toIndentedString(this.slots)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private Map<String, Object> arguments;
        private Map<String, SlotValue> slots;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="arguments")
        public Builder withArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder putArgumentsItem(String key, Object argumentsItem) {
            if (this.arguments == null) {
                this.arguments = new HashMap<String, Object>();
            }
            this.arguments.put(key, argumentsItem);
            return this;
        }

        @JsonProperty(value="slots")
        public Builder withSlots(Map<String, SlotValue> slots) {
            this.slots = slots;
            return this;
        }

        public Builder putSlotsItem(String key, SlotValue slotsItem) {
            if (this.slots == null) {
                this.slots = new HashMap<String, SlotValue>();
            }
            this.slots.put(key, slotsItem);
            return this;
        }

        public APIRequest build() {
            return new APIRequest(this);
        }
    }
}

