/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.CaptionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class CaptionData {
    @JsonProperty(value="content")
    private String content = null;
    @JsonProperty(value="type")
    private String type = null;

    public static Builder builder() {
        return new Builder();
    }

    private CaptionData(Builder builder) {
        if (builder.content != null) {
            this.content = builder.content;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public CaptionType getType() {
        return CaptionType.fromValue(this.type);
    }

    @JsonProperty(value="type")
    public String getTypeAsString() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptionData interfacesAudioplayerCaptionData = (CaptionData)o;
        return Objects.equals(this.content, interfacesAudioplayerCaptionData.content) && Objects.equals(this.type, interfacesAudioplayerCaptionData.type);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaptionData {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String content;
        private String type;

        private Builder() {
        }

        @JsonProperty(value="content")
        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withType(CaptionType type) {
            this.type = type != null ? type.toString() : null;
            return this;
        }

        public CaptionData build() {
            return new CaptionData(this);
        }
    }
}

